//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>..
 
report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Customers.Reports.Sales");
report.setReport("/com/openbravo/reports/sales_per_location");
report.setResourceBundle("com/openbravo/reports/sales_per_location");

report.setSentence("SELECT " +
                "'ALL' as ALLSALES, " +
                "locations.name as LOCATION, " +
                "closedcash.HOSTSEQUENCE, " +
                "closedcash.DATESTART," +
                "closedcash.DATEEND, " +
                "tickets.TICKETID AS TICKET_NO, " +
                "DATE(receipts.DATENEW) AS TICKET_DATE, " +
                "TIME(receipts.DATENEW) AS TICKET_TIME, " +
                "people.NAME AS PERSON, " +
                "CASE " +
                "    WHEN payments.PAYMENT = 'slip' then payments.TOTAL " +
                "	else null " +
                "end AS SLIP,   " +
                "CASE " +
                "    WHEN payments.PAYMENT = 'free' then payments.TOTAL " +
                "	else null " +
                "end AS FREE,   " +
                "CASE " +
                "    WHEN payments.PAYMENT = 'bank' then payments.TOTAL " +
                "	else null " +
                "end AS BANK,   " +
                "CASE " +
                "    WHEN payments.PAYMENT = 'ccard' then payments.TOTAL " +
                "	else null " +
                "end AS CREDIT,   " +
                "CASE " +
                "    WHEN payments.PAYMENT = 'cheque' or payments.PAYMENT = 'chequerefund' then payments.TOTAL " +
                "	else null " +
                "end AS CARD,   " +
                "CASE " +
                "    WHEN payments.PAYMENT = 'cash' or payments.PAYMENT = 'cashrefund'  then payments.TOTAL " +
                "	else null " +
                "end AS CASH,  " +
                "payments.TOTAL AS TOTAL " +
                "FROM" +
                "(" +
                "(tickets tickets " +
                "LEFT OUTER JOIN people people " +
                "ON (tickets.PERSON = people.ID) " +
                ") " +
                "RIGHT OUTER JOIN receipts receipts " +
                "ON (receipts.ID = tickets.ID) " +
                "LEFT OUTER JOIN closedcash closedcash  " +
                "ON (closedcash.money = receipts.money) " +
                "inner join resources " +
                "on (resources.name = concat(closedcash.host,'/properties')) " +
                "inner join locations " +
                "on locations.id = ExtractValue(CONVERT(content USING utf8), '/properties/entry[@key=\"location\"]')    " +
                ")  " +
                "LEFT OUTER JOIN payments payments  " +
                "ON (receipts.ID = payments.RECEIPT) " +
                "WHERE ?(QBF_FILTER) " +
                "ORDER BY LOCATION, closedcash.DATESTART,closedcash.DATEEND, TICKET_DATE, TICKET_TIME  ASC");

report.addParameter("receipts.DATENEW");
report.addParameter("closedcash.DATEEND");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
//paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addParameter("locations.id");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsLocationWithFirst());

//report.addParameter("customers.ID");
//report.addParameter("customers.NAME");
//report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addField("ALLSALES", com.openbravo.data.loader.Datas.STRING);
report.addField("LOCATION", com.openbravo.data.loader.Datas.STRING);
report.addField("HOSTSEQUENCE", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("DATESTART", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("DATEEND", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("TICKET_NO", com.openbravo.data.loader.Datas.STRING);
report.addField("TICKET_DATE", com.openbravo.data.loader.Datas.STRING);
report.addField("TICKET_TIME", com.openbravo.data.loader.Datas.STRING);
report.addField("PERSON", com.openbravo.data.loader.Datas.STRING);
report.addField("SLIP", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("FREE", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("BANK", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("CREDIT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("CARD", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("CASH", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

report;