//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Voucher");
report.setReport("/com/openbravo/reports/vouchers");
report.setResourceBundle("com/openbravo/reports/vouchers_messages");

report.setSentence("SELECT payments.receipt, " +
       "SUM(payments.total) AS TOTAL, "
       "receipts.DATENEW AS STARTDATE, receipts.DATENEW AS ENDDATE, "
       "tickets.ticketid AS TICKETID "
       "payments.voucher AS VOUCHERNUM" +
    "FROM (payments payments " +
        "INNER JOIN receipts receipts " +
            "ON (payments.receipt = receipts.id)) " +
        "INNER JOIN tickets tickets ON (tickets.id = receipts.id) " +
    "WHERE (UPPER(payments.voucher) NOT LIKE UPPER('0'))");

report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();
paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());
report.addQBFFilter(paramdates);

report.addField("RECEIPT", com.openbravo.data.loader.Datas.STRING);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("STARTDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("ENDDATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("VOUCHERNUM", com.openbravo.data.loader.Datas.STRING);

report;
