/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import bsh.EvalError;
import bsh.Interpreter;
import com.alee.extended.button.WebSwitch;
import com.alee.extended.time.ClockType;
import com.alee.extended.time.WebClock;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationManager;
import com.alee.managers.notification.WebNotification;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.JNumberEvent;
import com.openbravo.beans.JNumberEventListener;
import com.openbravo.beans.JNumberKeys;
import com.openbravo.beans.JNumberPop;
import com.openbravo.data.gui.ComboBoxValModel;
import com.openbravo.data.gui.ListKeyed;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.loader.SentenceList;
import com.openbravo.pos.customers.CustomerInfoExt;
import com.openbravo.pos.customers.CustomerInfoGlobal;
import com.openbravo.pos.customers.DataLogicCustomers;
import com.openbravo.pos.customers.JCustomerFinder;
import com.openbravo.pos.customers.JDialogNewCustomer;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.DataLogicSales;
import com.openbravo.pos.forms.DataLogicSystem;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.inventory.ProductStock;
import com.openbravo.pos.inventory.TaxCategoryInfo;
import com.openbravo.pos.panels.JProductFinder;
import com.openbravo.pos.payment.JPaymentSelect;
import com.openbravo.pos.payment.JPaymentSelectReceipt;
import com.openbravo.pos.payment.JPaymentSelectRefund;
import com.openbravo.pos.printer.TicketParser;
import com.openbravo.pos.printer.TicketPrinterException;
import com.openbravo.pos.sales.DataLogicReceipts;
import com.openbravo.pos.sales.JMooringDetails;
import com.openbravo.pos.sales.JPanelButtons;
import com.openbravo.pos.sales.JProductAttEdit2;
import com.openbravo.pos.sales.JProductLineEdit;
import com.openbravo.pos.sales.JTicketLines;
import com.openbravo.pos.sales.JTicketsBag;
import com.openbravo.pos.sales.KitchenDisplay;
import com.openbravo.pos.sales.ReceiptSplit;
import com.openbravo.pos.sales.TaxesException;
import com.openbravo.pos.sales.TaxesLogic;
import com.openbravo.pos.sales.TicketsEditor;
import com.openbravo.pos.sales.restaurant.RestaurantDBUtils;
import com.openbravo.pos.scale.ScaleException;
import com.openbravo.pos.scripting.ScriptEngine;
import com.openbravo.pos.scripting.ScriptException;
import com.openbravo.pos.scripting.ScriptFactory;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketTaxInfo;
import com.openbravo.pos.util.AltEncrypter;
import com.openbravo.pos.util.InactivityListener;
import com.openbravo.pos.util.JRPrinterAWT300;
import com.openbravo.pos.util.ReportUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public abstract class JPanelTicket
extends JPanel
implements JPanelView,
BeanFactoryApp,
TicketsEditor {
    private static final int NUMBERZERO = 0;
    private static final int NUMBERVALID = 1;
    private static final int NUMBER_INPUTZERO = 0;
    private static final int NUMBER_INPUTZERODEC = 1;
    private static final int NUMBER_INPUTINT = 2;
    private static final int NUMBER_INPUTDEC = 3;
    private static final int NUMBER_PORZERO = 4;
    private static final int NUMBER_PORZERODEC = 5;
    private static final int NUMBER_PORINT = 6;
    private static final int NUMBER_PORDEC = 7;
    protected JTicketLines m_ticketlines;
    private TicketParser m_TTP;
    protected TicketInfo m_oTicket;
    protected Object m_oTicketExt;
    private int m_iNumberStatus;
    private int m_iNumberStatusInput;
    private int m_iNumberStatusPor;
    private StringBuffer m_sBarcode;
    private JTicketsBag m_ticketsbag;
    private SentenceList senttax;
    private ListKeyed taxcollection;
    private SentenceList senttaxcategories;
    private ListKeyed taxcategoriescollection;
    private ComboBoxValModel taxcategoriesmodel;
    private TaxesLogic taxeslogic;
    protected JPanelButtons m_jbtnconfig;
    protected AppView m_App;
    protected DataLogicSystem dlSystem;
    protected DataLogicSales dlSales;
    protected DataLogicCustomers dlCustomers;
    private JPaymentSelect paymentdialogreceipt;
    private JPaymentSelect paymentdialogrefund;
    private JRootApp root;
    private Object m_principalapp;
    private Boolean restaurant;
    private Boolean orderlistopen;
    private Action logout;
    private InactivityListener listener;
    private Integer delay = 0;
    private final String m_sCurrentTicket;
    protected TicketsEditor m_panelticket;
    private DataLogicReceipts dlReceipts = null;
    private Boolean priceWith00;
    private final String temp_jPrice = "";
    private String tableDetails;
    private RestaurantDBUtils restDB;
    private KitchenDisplay kitchenDisplay;
    private String ticketPrintType;
    private Boolean warrantyPrint = false;
    private TicketInfo m_ticket;
    private TicketInfo m_ticketCopy;
    private AppConfig m_config;
    private Integer count = 0;
    private Integer oCount = 0;
    private Boolean pinOK;
    private JButton btnReprint1;
    private JButton btnSplit;
    private JPanel catcontainer;
    private Box.Filler filler2;
    private JButton jBtnCustomer;
    private JButton jCheckStock;
    private JButton jEditAttributes;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel9;
    private JToggleButton jTBtnShow;
    private JButton j_btnRemotePrt;
    private JButton jbtnMooring;
    private JPanel m_jButtons;
    private JPanel m_jButtonsExt;
    private JPanel m_jContEntries;
    private JButton m_jDelete;
    private JButton m_jEditLine;
    private JButton m_jEnter;
    private JTextField m_jKeyFactory;
    private JLabel m_jLblTotalEuros1;
    private JLabel m_jLblTotalEuros2;
    private JLabel m_jLblTotalEuros3;
    private JButton m_jList;
    private JNumberKeys m_jNumberKeys;
    private JPanel m_jOptions;
    private JPanel m_jPanContainer;
    private JPanel m_jPanEntries;
    private JPanel m_jPanTicket;
    private JPanel m_jPanTotals;
    private JPanel m_jPanelBag;
    private JPanel m_jPanelCentral;
    private JPanel m_jPanelScripts;
    private JLabel m_jPor;
    private JLabel m_jPrice;
    private JLabel m_jSubtotalEuros;
    private JComboBox m_jTax;
    private JLabel m_jTaxesEuros;
    private JLabel m_jTicketId;
    private JLabel m_jTotalEuros;
    private WebSwitch m_jaddtax;
    private JButton m_jbtnScale;

    public JPanelTicket() {
        this.m_sCurrentTicket = null;
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_config = new AppConfig(new File(System.getProperty("user.home"), "unicentaopos.properties"));
        this.m_config.load();
        this.m_App = app;
        this.restDB = new RestaurantDBUtils(this.m_App);
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.pos.forms.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.pos.forms.DataLogicSales");
        this.dlCustomers = (DataLogicCustomers)this.m_App.getBean("com.openbravo.pos.customers.DataLogicCustomers");
        this.dlReceipts = (DataLogicReceipts)app.getBean("com.openbravo.pos.sales.DataLogicReceipts");
        this.m_ticketsbag = this.getJTicketsBag();
        this.m_jPanelBag.add((Component)this.m_ticketsbag.getBagComponent(), "Before");
        this.add((Component)this.m_ticketsbag.getNullComponent(), "null");
        this.m_jbtnconfig = new JPanelButtons("Ticket.Buttons", this);
        this.m_jButtonsExt.add(this.m_jbtnconfig);
        if (!this.m_App.getDeviceScale().existsScale()) {
            this.m_jbtnScale.setVisible(false);
        }
        this.jbtnMooring.setVisible(Boolean.valueOf(this.m_App.getProperties().getProperty("till.marineoption")));
        this.m_jPanelScripts.setVisible(false);
        this.m_jButtonsExt.setVisible(false);
        this.jTBtnShow.setSelected(false);
        if (Boolean.valueOf(this.m_App.getProperties().getProperty("till.amountattop")).booleanValue()) {
            this.m_jPanEntries.remove(this.jPanel9);
            this.m_jPanEntries.remove(this.m_jNumberKeys);
            this.m_jPanEntries.add(this.jPanel9);
            this.m_jPanEntries.add(this.m_jNumberKeys);
        }
        this.priceWith00 = "true".equals(this.m_App.getProperties().getProperty("till.pricewith00"));
        if (this.priceWith00.booleanValue()) {
            this.m_jNumberKeys.dotIs00(true);
        }
        this.m_ticketlines = new JTicketLines(this.dlSystem.getResourceAsXML("Ticket.Line"));
        this.m_jPanelCentral.add((Component)this.m_ticketlines, "Center");
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.dlSystem);
        this.catcontainer.add(this.getSouthComponent(), "Center");
        this.senttax = this.dlSales.getTaxList();
        this.senttaxcategories = this.dlSales.getTaxCategoriesList();
        this.taxcategoriesmodel = new ComboBoxValModel();
        this.stateToZero();
        this.m_oTicket = null;
        this.m_oTicketExt = null;
        this.jCheckStock.setText(AppLocal.getIntString("message.title.checkstock"));
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void closeAllDialogs() {
        Window[] windows;
        for (Window window : windows = Window.getWindows()) {
            if (!(window instanceof JDialog)) continue;
            window.dispose();
        }
    }

    private void saveCurrentTicket() {
        String currentTicket = (String)this.m_oTicketExt;
        if (currentTicket != null) {
            try {
                this.dlReceipts.updateSharedTicket(currentTicket, this.m_oTicket, this.m_oTicket.getPickupId());
            }
            catch (BasicException ex) {
                Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void activate() throws BasicException {
        logout logout2 = new logout();
        String autoLogoff = this.m_App.getProperties().getProperty("till.autoLogoff");
        if (autoLogoff != null && autoLogoff.equals("true")) {
            try {
                this.delay = Integer.parseInt(this.m_App.getProperties().getProperty("till.autotimer"));
            }
            catch (NumberFormatException e) {
                this.delay = 0;
            }
            this.delay = this.delay * 1000;
        }
        if (this.delay != 0) {
            this.listener = new InactivityListener(logout2, this.delay);
            this.listener.start();
        }
        this.paymentdialogreceipt = JPaymentSelectReceipt.getDialog(this);
        this.paymentdialogreceipt.init(this.m_App);
        this.paymentdialogrefund = JPaymentSelectRefund.getDialog(this);
        this.paymentdialogrefund.init(this.m_App);
        this.m_jaddtax.setSelected("true".equals(this.m_jbtnconfig.getProperty("taxesincluded")));
        List taxlist = this.senttax.list();
        this.taxcollection = new ListKeyed(taxlist);
        List taxcategorieslist = this.senttaxcategories.list();
        this.taxcategoriescollection = new ListKeyed(taxcategorieslist);
        this.taxcategoriesmodel = new ComboBoxValModel(taxcategorieslist);
        this.m_jTax.setModel(this.taxcategoriesmodel);
        String taxesid = this.m_jbtnconfig.getProperty("taxcategoryid");
        if (taxesid == null) {
            if (this.m_jTax.getItemCount() > 0) {
                this.m_jTax.setSelectedIndex(0);
            }
        } else {
            this.taxcategoriesmodel.setSelectedKey(taxesid);
        }
        this.taxeslogic = new TaxesLogic(taxlist);
        this.m_jaddtax.setSelected(Boolean.parseBoolean(this.m_App.getProperties().getProperty("till.taxincluded")));
        if (this.m_App.getAppUserView().getUser().hasPermission("sales.ChangeTaxOptions")) {
            this.m_jTax.setVisible(true);
            this.m_jaddtax.setVisible(true);
        } else {
            this.m_jTax.setVisible(false);
            this.m_jaddtax.setVisible(false);
        }
        this.m_jDelete.setEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines"));
        this.m_jNumberKeys.setMinusEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines"));
        this.m_jNumberKeys.setEqualsEnabled(this.m_App.getAppUserView().getUser().hasPermission("sales.Total"));
        this.m_jbtnconfig.setPermissions(this.m_App.getAppUserView().getUser());
        this.m_ticketsbag.setEnabled(false);
        this.m_ticketsbag.activate();
        CustomerInfoGlobal customerInfoGlobal = CustomerInfoGlobal.getInstance();
        if (customerInfoGlobal.getCustomerInfoExt() != null && this.m_oTicket != null) {
            this.m_oTicket.setCustomer(customerInfoGlobal.getCustomerInfoExt());
        }
        this.refreshTicket();
    }

    @Override
    public boolean deactivate() {
        if (this.listener != null) {
            this.listener.stop();
        }
        return this.m_ticketsbag.deactivate();
    }

    protected abstract JTicketsBag getJTicketsBag();

    protected abstract Component getSouthComponent();

    protected abstract void resetSouthComponent();

    @Override
    public void setActiveTicket(TicketInfo oTicket, Object oTicketExt) {
        switch (this.m_App.getProperties().getProperty("machine.ticketsbag")) {
            case "restaurant": {
                if (!"true".equals(this.m_App.getProperties().getProperty("till.autoLogoffrestaurant")) || this.listener == null) break;
                this.listener.restart();
            }
        }
        this.m_oTicket = oTicket;
        this.m_oTicketExt = oTicketExt;
        if (this.m_oTicket != null) {
            this.m_oTicket.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
            this.m_oTicket.setActiveCash(this.m_App.getActiveCashIndex());
            this.m_oTicket.setDate(new Date());
            if ("restaurant".equals(this.m_App.getProperties().getProperty("machine.ticketsbag")) && !oTicket.getOldTicket()) {
                if (this.restDB.getCustomerNameInTable(oTicketExt.toString()) == null && this.m_oTicket.getCustomer() != null) {
                    this.restDB.setCustomerNameInTable(this.m_oTicket.getCustomer().toString(), oTicketExt.toString());
                }
                if (this.restDB.getWaiterNameInTable(oTicketExt.toString()) == null || "".equals(this.restDB.getWaiterNameInTable(oTicketExt.toString()))) {
                    this.restDB.setWaiterNameInTable(this.m_App.getAppUserView().getUser().getName(), oTicketExt.toString());
                }
                this.restDB.setTicketIdInTable(this.m_oTicket.getId(), oTicketExt.toString());
            }
        }
        if (this.m_oTicket == null || Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showwaiterdetails")) || Boolean.valueOf(this.m_App.getProperties().getProperty("table.showcustomerdetails")).booleanValue()) {
            // empty if block
        }
        if (this.m_oTicket != null && (Boolean.valueOf(this.m_App.getProperties().getProperty("table.showcustomerdetails")).booleanValue() || Boolean.parseBoolean(this.m_App.getProperties().getProperty("table.showwaiterdetails"))) && this.restDB.getTableMovedFlag(this.m_oTicket.getId()).booleanValue()) {
            this.restDB.moveCustomer(oTicketExt.toString(), this.m_oTicket.getId());
        }
        this.executeEvent(this.m_oTicket, this.m_oTicketExt, "ticket.show", new ScriptArg[0]);
        if (this.m_App.getAppUserView().getUser().hasPermission("sales.PrintRemote")) {
            this.j_btnRemotePrt.setEnabled(true);
        } else {
            this.j_btnRemotePrt.setEnabled(false);
        }
        this.refreshTicket();
    }

    @Override
    public TicketInfo getActiveTicket() {
        return this.m_oTicket;
    }

    private void refreshTicket() {
        CardLayout cl = (CardLayout)this.getLayout();
        if (this.m_oTicket == null) {
            this.m_jTicketId.setText(null);
            this.m_ticketlines.clearTicketLines();
            this.m_jSubtotalEuros.setText(null);
            this.m_jTaxesEuros.setText(null);
            this.m_jTotalEuros.setText(null);
            this.jCheckStock.setText(null);
            this.checkStock();
            this.stateToZero();
            this.repaint();
            cl.show(this, "null");
            if (this.m_oTicket != null && this.m_oTicket.getLinesCount() == 0) {
                this.resetSouthComponent();
            }
        } else {
            if (this.m_oTicket.getTicketType() == 1) {
                this.m_jEditLine.setVisible(false);
                this.m_jList.setVisible(false);
            }
            this.m_oTicket.getLines().forEach(line -> line.setTaxInfo(this.taxeslogic.getTaxInfo(line.getProductTaxCategoryID(), this.m_oTicket.getCustomer())));
            this.m_jTicketId.setText(this.m_oTicket.getName(this.m_oTicketExt));
            this.m_ticketlines.clearTicketLines();
            for (int i = 0; i < this.m_oTicket.getLinesCount(); ++i) {
                this.m_ticketlines.addTicketLine(this.m_oTicket.getLine(i));
            }
            this.countArticles();
            this.printPartialTotals();
            this.stateToZero();
            cl.show(this, "ticket");
            if (this.m_oTicket.getLinesCount() == 0) {
                this.resetSouthComponent();
            }
            this.m_jKeyFactory.setText(null);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPanelTicket.this.m_jKeyFactory.requestFocus();
                }
            });
        }
    }

    private void countArticles() {
        this.oCount = this.count;
        this.count = (int)this.m_oTicket.getArticlesCount();
        if (this.m_oTicket != null) {
            for (int i = 0; i < this.m_oTicket.getLinesCount(); ++i) {
                if (this.m_App.getAppUserView().getUser().hasPermission("sales.Total") && this.m_oTicket.getArticlesCount() > 1.0) {
                    this.btnSplit.setEnabled(true);
                    continue;
                }
                this.btnSplit.setEnabled(false);
            }
        }
    }

    private boolean changeCount(boolean pinOK) {
        pinOK = false;
        if (this.m_oTicket != null && this.m_App.getProperties().getProperty("override.check").equals("true")) {
            Integer secret = Integer.parseInt(this.m_App.getProperties().getProperty("override.pin"));
            Integer iValue = JNumberPop.showEditNumber(this, AppLocal.getIntString("title.override.enterpin"));
            if (iValue == null ? secret == null : iValue.equals(secret)) {
                pinOK = true;
                JOptionPane.showMessageDialog(this, "Units changed from " + this.count + " to " + this.oCount);
                return pinOK;
            }
            pinOK = false;
            JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.override.badpin"));
            return pinOK;
        }
        return pinOK;
    }

    private void printPartialTotals() {
        if (this.m_oTicket.getLinesCount() == 0) {
            this.m_jSubtotalEuros.setText(null);
            this.m_jTaxesEuros.setText(null);
            this.m_jTotalEuros.setText(null);
        } else {
            this.m_jSubtotalEuros.setText(this.m_oTicket.printSubTotal());
            this.m_jTaxesEuros.setText(this.m_oTicket.printTax());
            this.m_jTotalEuros.setText(this.m_oTicket.printTotal());
        }
        this.repaint();
    }

    private void paintTicketLine(int index, TicketLineInfo oLine) {
        if (this.executeEventAndRefresh("ticket.setline", new ScriptArg("index", index), new ScriptArg("line", oLine)) == null) {
            this.m_oTicket.setLine(index, oLine);
            this.m_ticketlines.setTicketLine(index, oLine);
            this.m_ticketlines.setSelectedIndex(index);
            this.oCount = this.count;
            this.countArticles();
            this.visorTicketLine(oLine);
            this.printPartialTotals();
            this.stateToZero();
            this.executeEventAndRefresh("ticket.change", new ScriptArg[0]);
        }
    }

    private void addTicketLine(ProductInfoExt oProduct, double dMul, double dPrice) {
        if (oProduct.isVprice() || oProduct.getID().equals("xxx999_999xxx_x9x9x9")) {
            TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
            if (this.m_jaddtax.isSelected()) {
                dPrice /= 1.0 + tax.getRate();
            }
            this.addTicketLine(new TicketLineInfo(oProduct, dMul, dPrice, tax, (Properties)oProduct.getProperties().clone()));
        } else if (oProduct.getID().equals("xxx998_998xxx_x8x8x8")) {
            if (this.m_App.getProperties().getProperty("till.SCOnOff").equals("true")) {
                TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
                String SCRate = this.m_App.getProperties().getProperty("till.SCRate");
                double scharge = Double.parseDouble(SCRate);
                scharge = this.m_oTicket.getTotal() * (scharge / 100.0);
                this.addTicketLine(new TicketLineInfo(oProduct, 1.0, scharge, tax, (Properties)oProduct.getProperties().clone()));
            } else {
                JOptionPane.showMessageDialog(this, "Service Charge Not Enabled");
            }
        } else {
            TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
            this.addTicketLine(new TicketLineInfo(oProduct, dMul, dPrice, tax, (Properties)oProduct.getProperties().clone()));
            this.refreshTicket();
        }
        this.j_btnRemotePrt.setEnabled(true);
    }

    protected void addTicketLine(TicketLineInfo oLine) {
        if (this.executeEventAndRefresh("ticket.addline", new ScriptArg("line", oLine)) == null) {
            if (oLine.isProductCom()) {
                int i = this.m_ticketlines.getSelectedIndex();
                if (i >= 0 && !this.m_oTicket.getLine(i).isProductCom()) {
                    ++i;
                }
                while (i >= 0 && i < this.m_oTicket.getLinesCount() && this.m_oTicket.getLine(i).isProductCom()) {
                    ++i;
                }
                if (i >= 0) {
                    this.m_oTicket.insertLine(i, oLine);
                    this.m_ticketlines.insertTicketLine(i, oLine);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                this.m_oTicket.addLine(oLine);
                this.m_ticketlines.addTicketLine(oLine);
                try {
                    int i = this.m_ticketlines.getSelectedIndex();
                    TicketLineInfo line = this.m_oTicket.getLine(i);
                    if (line.isProductVerpatrib()) {
                        JProductAttEdit2 attedit = JProductAttEdit2.getAttributesEditor(this, this.m_App.getSession());
                        attedit.editAttributes(line.getProductAttSetId(), line.getProductAttSetInstId());
                        attedit.setVisible(true);
                        if (attedit.isOK()) {
                            line.setProductAttSetInstId(attedit.getAttributeSetInst());
                            line.setProductAttSetInstDesc(attedit.getAttributeSetInstDescription());
                            this.paintTicketLine(i, line);
                        }
                    }
                }
                catch (BasicException ex) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindattributes"), ex);
                    msg.show(this);
                }
            }
            this.visorTicketLine(oLine);
            this.printPartialTotals();
            this.stateToZero();
            this.checkStock();
            this.countArticles();
            this.executeEvent(this.m_oTicket, this.m_oTicketExt, "ticket.change", new ScriptArg[0]);
        }
    }

    private void removeTicketLine(int i) {
        if (this.executeEventAndRefresh("ticket.removeline", new ScriptArg("index", i)) == null) {
            String ticketID = Integer.toString(this.m_oTicket.getTicketId());
            if (this.m_oTicket.getTicketId() == 0) {
                ticketID = "Void";
            }
            this.dlSystem.execLineRemoved(new Object[]{this.m_App.getAppUserView().getUser().getName(), ticketID, this.m_oTicket.getLine(i).getProductID(), this.m_oTicket.getLine(i).getProductName(), this.m_oTicket.getLine(i).getMultiply()});
            if (this.m_oTicket.getLine(i).isProductCom()) {
                this.m_oTicket.removeLine(i);
                this.m_ticketlines.removeTicketLine(i);
            } else if (i < 1) {
                if (this.m_App.getAppUserView().getUser().hasPermission("sales.DeleteLines")) {
                    int input = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.deletelineyes"), AppLocal.getIntString("label.deleteline"), 0);
                    if (input == 0) {
                        this.m_oTicket.removeLine(i);
                        this.m_ticketlines.removeTicketLine(i);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.deletelineno"), AppLocal.getIntString("label.deleteline"), 2);
                }
            } else {
                this.m_oTicket.removeLine(i);
                this.m_ticketlines.removeTicketLine(i);
                while (i < this.m_oTicket.getLinesCount() && this.m_oTicket.getLine(i).isProductCom()) {
                    this.m_oTicket.removeLine(i);
                    this.m_ticketlines.removeTicketLine(i);
                }
            }
            this.visorTicketLine(null);
            this.printPartialTotals();
            this.stateToZero();
            this.checkStock();
            this.countArticles();
            this.executeEventAndRefresh("ticket.change", new ScriptArg[0]);
        }
    }

    private ProductInfoExt getInputProduct() {
        ProductInfoExt oProduct = new ProductInfoExt();
        oProduct.setID("xxx999_999xxx_x9x9x9");
        oProduct.setReference("xxx999");
        oProduct.setCode("xxx999");
        oProduct.setName("***");
        oProduct.setTaxCategoryID(((TaxCategoryInfo)this.taxcategoriesmodel.getSelectedItem()).getID());
        oProduct.setPriceSell(this.includeTaxes(oProduct.getTaxCategoryID(), this.getInputValue()));
        return oProduct;
    }

    private double includeTaxes(String tcid, double dValue) {
        if (this.m_jaddtax.isSelected()) {
            TaxInfo tax = this.taxeslogic.getTaxInfo(tcid, this.m_oTicket.getCustomer());
            double dTaxRate = tax == null ? 0.0 : tax.getRate();
            return dValue / (1.0 + dTaxRate);
        }
        return dValue;
    }

    private double excludeTaxes(String tcid, double dValue) {
        TaxInfo tax = this.taxeslogic.getTaxInfo(tcid, this.m_oTicket.getCustomer());
        double dTaxRate = tax == null ? 0.0 : tax.getRate();
        return dValue / (1.0 + dTaxRate);
    }

    private double getInputValue() {
        try {
            return Double.parseDouble(this.m_jPrice.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private double getPorValue() {
        try {
            return Double.parseDouble(this.m_jPor.getText().substring(1));
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            return 1.0;
        }
    }

    private void stateToZero() {
        this.m_jPor.setText("");
        this.m_jPrice.setText("");
        this.m_sBarcode = new StringBuffer();
        this.m_iNumberStatus = 0;
        this.m_iNumberStatusInput = 0;
        this.m_iNumberStatusPor = 0;
        this.repaint();
    }

    private void incProductByCode(String sCode) {
        try {
            ProductInfoExt oProduct = this.dlSales.getProductInfoByCode(sCode);
            if (oProduct == null) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, sCode + " - " + AppLocal.getIntString("message.noproduct"), "Check", 2);
                this.stateToZero();
            } else {
                this.incProduct(oProduct);
            }
        }
        catch (BasicException eData) {
            this.stateToZero();
            new MessageInf(eData).show(this);
        }
    }

    private void incProductByCodePrice(String sCode, double dPriceSell) {
        try {
            ProductInfoExt oProduct = this.dlSales.getProductInfoByCode(sCode);
            if (oProduct == null) {
                Toolkit.getDefaultToolkit().beep();
                new MessageInf(-33554432, AppLocal.getIntString("message.noproduct")).show(this);
                this.stateToZero();
            } else if (this.m_jaddtax.isSelected()) {
                TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
                this.addTicketLine(oProduct, 1.0, dPriceSell / (1.0 + tax.getRate()));
            } else {
                this.addTicketLine(oProduct, 1.0, dPriceSell);
            }
        }
        catch (BasicException eData) {
            this.stateToZero();
            new MessageInf(eData).show(this);
        }
    }

    private void incProduct(ProductInfoExt prod) {
        if (prod.isScale() && this.m_App.getDeviceScale().existsScale()) {
            try {
                Double value = this.m_App.getDeviceScale().readWeight();
                if (value != null) {
                    this.incProduct(value, prod);
                }
            }
            catch (ScaleException e) {
                Toolkit.getDefaultToolkit().beep();
                new MessageInf(-33554432, AppLocal.getIntString("message.noweight"), e).show(this);
                this.stateToZero();
            }
        } else if (!prod.isVprice()) {
            this.incProduct(1.0, prod);
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, AppLocal.getIntString("message.novprice"));
        }
    }

    private void incProduct(double dPor, ProductInfoExt prod) {
        if (prod.isVprice()) {
            this.addTicketLine(prod, this.getPorValue(), this.getInputValue());
        } else {
            this.addTicketLine(prod, dPor, prod.getPriceSell());
        }
    }

    protected void buttonTransition(ProductInfoExt prod) {
        if (this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0) {
            this.incProduct(prod);
        } else if (this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0) {
            this.incProduct(this.getInputValue(), prod);
        } else if (prod.isVprice()) {
            this.addTicketLine(prod, this.getPorValue(), this.getInputValue());
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void stateTransition(char cTrans) {
        block192: {
            if (cTrans == '\n' || cTrans == '?') {
                if (this.m_sBarcode.length() > 0) {
                    String sCode = this.m_sBarcode.toString();
                    String sCodetype = "EAN";
                    sCodetype = "true".equals(this.m_App.getProperties().getProperty("machine.barcodetype")) ? "UPC" : "EAN";
                    if (sCode.startsWith("C") || sCode.startsWith("c")) {
                        try {
                            String card = sCode;
                            CustomerInfoExt newcustomer = this.dlSales.findCustomerExt(card);
                            if (newcustomer == null) {
                                Toolkit.getDefaultToolkit().beep();
                                new MessageInf(-33554432, AppLocal.getIntString("message.nocustomer")).show(this);
                            } else {
                                this.m_oTicket.setCustomer(newcustomer);
                                this.m_jTicketId.setText(this.m_oTicket.getName(this.m_oTicketExt));
                            }
                        }
                        catch (BasicException e) {
                            Toolkit.getDefaultToolkit().beep();
                            new MessageInf(-33554432, AppLocal.getIntString("message.nocustomer"), e).show(this);
                        }
                        this.stateToZero();
                    } else if (sCode.startsWith(";")) {
                        this.stateToZero();
                    } else if ("EAN".equals(sCodetype) && (sCode.startsWith("2") || sCode.startsWith("02")) && (sCode.length() == 13 || sCode.length() == 12)) {
                        try {
                            ProductInfoExt oProduct = this.dlSales.getProductInfoByShortCode(sCode);
                            if (oProduct == null) {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(null, sCode + " - " + AppLocal.getIntString("message.noproduct"), "Check", 2);
                                this.stateToZero();
                                break block192;
                            }
                            if (!"EAN-13".equals(oProduct.getCodetype())) break block192;
                            oProduct.setProperty("product.barcode", sCode);
                            double dPriceSell = oProduct.getPriceSell();
                            double weight = 0.0;
                            double dUnits = 0.0;
                            String sVariableTypePrefix = sCode.substring(0, 2);
                            String sVariableNum = sCode.length() == 13 ? sCode.substring(8, 12) : sCode.substring(7, 11);
                            switch (sVariableTypePrefix) {
                                case "02": {
                                    dUnits = Double.parseDouble(sVariableNum) / 100.0 / oProduct.getPriceSell();
                                    break;
                                }
                                case "20": {
                                    dUnits = Double.parseDouble(sVariableNum) / 100.0 / oProduct.getPriceSell();
                                    break;
                                }
                                case "21": {
                                    dUnits = Double.parseDouble(sVariableNum) / 10.0 / oProduct.getPriceSell();
                                    break;
                                }
                                case "22": {
                                    dUnits = Double.parseDouble(sVariableNum) / oProduct.getPriceSell();
                                    break;
                                }
                                case "23": {
                                    dUnits = weight = Double.parseDouble(sVariableNum) / 1000.0;
                                    break;
                                }
                                case "24": {
                                    dUnits = weight = Double.parseDouble(sVariableNum) / 100.0;
                                    break;
                                }
                                case "25": {
                                    dUnits = weight = Double.parseDouble(sVariableNum) / 10.0;
                                    break;
                                }
                            }
                            TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
                            switch (sVariableTypePrefix) {
                                case "02": {
                                    dPriceSell = oProduct.getPriceSellTax(tax) / (1.0 + tax.getRate());
                                    dUnits = Double.parseDouble(sVariableNum) / 100.0 / oProduct.getPriceSellTax(tax);
                                    oProduct.setProperty("product.price", Double.toString(oProduct.getPriceSell()));
                                    break;
                                }
                                case "20": {
                                    dPriceSell = oProduct.getPriceSellTax(tax) / (1.0 + tax.getRate());
                                    dUnits = Double.parseDouble(sVariableNum) / 100.0 / oProduct.getPriceSellTax(tax);
                                    oProduct.setProperty("product.price", Double.toString(oProduct.getPriceSellTax(tax)));
                                    break;
                                }
                                case "21": {
                                    dPriceSell = oProduct.getPriceSellTax(tax) / (1.0 + tax.getRate());
                                    dUnits = Double.parseDouble(sVariableNum) / 10.0 / oProduct.getPriceSellTax(tax);
                                    oProduct.setProperty("product.price", Double.toString(oProduct.getPriceSell()));
                                    break;
                                }
                                case "22": {
                                    dPriceSell = oProduct.getPriceSellTax(tax) / (1.0 + tax.getRate());
                                    dUnits = Double.parseDouble(sVariableNum) / 1.0 / oProduct.getPriceSellTax(tax);
                                    oProduct.setProperty("product.price", Double.toString(oProduct.getPriceSell()));
                                    break;
                                }
                                case "23": {
                                    dUnits = weight = Double.parseDouble(sVariableNum) / 1000.0;
                                    oProduct.setProperty("product.weight", Double.toString(weight));
                                    oProduct.setProperty("product.price", Double.toString(dPriceSell));
                                    break;
                                }
                                case "24": {
                                    dUnits = weight = Double.parseDouble(sVariableNum) / 100.0;
                                    oProduct.setProperty("product.weight", Double.toString(weight));
                                    oProduct.setProperty("product.price", Double.toString(dPriceSell));
                                    break;
                                }
                                case "25": {
                                    dUnits = weight = Double.parseDouble(sVariableNum) / 10.0;
                                    oProduct.setProperty("product.weight", Double.toString(weight));
                                    oProduct.setProperty("product.price", Double.toString(dPriceSell));
                                    break;
                                }
                            }
                            if (this.m_jaddtax.isSelected()) {
                                dPriceSell = oProduct.getPriceSellTax(tax);
                                this.addTicketLine(oProduct, dUnits, dPriceSell);
                                break block192;
                            }
                            this.addTicketLine(oProduct, dUnits, dPriceSell);
                        }
                        catch (BasicException eData) {
                            this.stateToZero();
                            new MessageInf(eData).show(this);
                        }
                    } else if ("UPC".equals(sCodetype) && sCode.startsWith("2") && sCode.length() == 12) {
                        try {
                            ProductInfoExt oProduct = this.dlSales.getProductInfoByUShortCode(sCode);
                            if (oProduct == null) {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(null, sCode + " - " + AppLocal.getIntString("message.noproduct"), "Check", 2);
                                this.stateToZero();
                                break block192;
                            }
                            if (!"Upc-A".equals(oProduct.getCodetype())) break block192;
                            oProduct.setProperty("product.barcode", sCode);
                            double dPriceSell = oProduct.getPriceSell();
                            double weight = 0.0;
                            double dUnits = 0.0;
                            String sVariableNum = sCode.substring(7, 11);
                            TaxInfo tax = this.taxeslogic.getTaxInfo(oProduct.getTaxCategoryID(), this.m_oTicket.getCustomer());
                            if (oProduct.getPriceSell() != 0.0) {
                                dUnits = weight = Double.parseDouble(sVariableNum) / 100.0;
                                oProduct.setProperty("product.weight", Double.toString(weight));
                                oProduct.setProperty("product.price", Double.toString(oProduct.getPriceSell()));
                                dPriceSell = oProduct.getPriceSellTax(tax);
                                dUnits = Double.parseDouble(sVariableNum) / 100.0 / oProduct.getPriceSellTax(tax);
                            } else {
                                dPriceSell = Double.parseDouble(sVariableNum) / 100.0;
                                dUnits = 1.0;
                            }
                            if (this.m_jaddtax.isSelected()) {
                                this.addTicketLine(oProduct, dUnits, dPriceSell);
                                break block192;
                            }
                            this.addTicketLine(oProduct, dUnits, dPriceSell / (1.0 + tax.getRate()));
                        }
                        catch (BasicException eData) {
                            this.stateToZero();
                            new MessageInf(eData).show(this);
                        }
                    } else {
                        this.incProductByCode(sCode);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                this.m_sBarcode.append(cTrans);
                if (cTrans == '\u007f') {
                    this.stateToZero();
                } else if (cTrans == '0' && this.m_iNumberStatus == 0) {
                    this.m_jPrice.setText(Character.toString('0'));
                } else if ((cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 0) {
                    if (!this.priceWith00.booleanValue()) {
                        this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                    } else {
                        this.m_jPrice.setText(this.setTempjPrice(this.m_jPrice.getText() + cTrans));
                    }
                    this.m_iNumberStatus = 2;
                    this.m_iNumberStatusInput = 1;
                } else if ((cTrans == '0' || cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 2) {
                    if (!this.priceWith00.booleanValue()) {
                        this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                    } else {
                        this.m_jPrice.setText(this.setTempjPrice(this.m_jPrice.getText() + cTrans));
                    }
                } else if (cTrans == '.' && this.m_iNumberStatus == 0 && !this.priceWith00.booleanValue()) {
                    this.m_jPrice.setText("0.");
                    this.m_iNumberStatus = 1;
                } else if (cTrans == '.' && this.m_iNumberStatus == 0) {
                    this.m_jPrice.setText("");
                    this.m_iNumberStatus = 0;
                } else if (cTrans == '.' && this.m_iNumberStatus == 2 && !this.priceWith00.booleanValue()) {
                    this.m_jPrice.setText(this.m_jPrice.getText() + ".");
                    this.m_iNumberStatus = 3;
                } else if (cTrans == '.' && this.m_iNumberStatus == 2) {
                    if (!this.priceWith00.booleanValue()) {
                        this.m_jPrice.setText(this.m_jPrice.getText() + "00");
                    } else {
                        this.m_jPrice.setText(this.setTempjPrice(this.m_jPrice.getText() + "00"));
                    }
                    this.m_iNumberStatus = 2;
                } else if (cTrans == '0' && (this.m_iNumberStatus == 1 || this.m_iNumberStatus == 3)) {
                    if (!this.priceWith00.booleanValue()) {
                        this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                    } else {
                        this.m_jPrice.setText(this.setTempjPrice(this.m_jPrice.getText() + cTrans));
                    }
                } else if (!(cTrans != '1' && cTrans != '2' && cTrans != '3' && cTrans != '4' && cTrans != '5' && cTrans != '6' && cTrans != '7' && cTrans != '8' && cTrans != '9' || this.m_iNumberStatus != 1 && this.m_iNumberStatus != 3)) {
                    this.m_jPrice.setText(this.m_jPrice.getText() + cTrans);
                    this.m_iNumberStatus = 3;
                    this.m_iNumberStatusInput = 1;
                } else if (cTrans == '*' && (this.m_iNumberStatus == 2 || this.m_iNumberStatus == 3)) {
                    this.m_jPor.setText("x");
                    this.m_iNumberStatus = 4;
                } else if (cTrans == '*' && (this.m_iNumberStatus == 0 || this.m_iNumberStatus == 1)) {
                    this.m_jPrice.setText("0");
                    this.m_jPor.setText("x");
                    this.m_iNumberStatus = 4;
                } else if (cTrans == '0' && this.m_iNumberStatus == 4) {
                    this.m_jPor.setText("x0");
                } else if ((cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 4) {
                    this.m_jPor.setText("x" + Character.toString(cTrans));
                    this.m_iNumberStatus = 6;
                    this.m_iNumberStatusPor = 1;
                } else if ((cTrans == '0' || cTrans == '1' || cTrans == '2' || cTrans == '3' || cTrans == '4' || cTrans == '5' || cTrans == '6' || cTrans == '7' || cTrans == '8' || cTrans == '9') && this.m_iNumberStatus == 6) {
                    this.m_jPor.setText(this.m_jPor.getText() + cTrans);
                } else if (cTrans == '.' && this.m_iNumberStatus == 4 && !this.priceWith00.booleanValue()) {
                    this.m_jPor.setText("x0.");
                    this.m_iNumberStatus = 5;
                } else if (cTrans == '.' && this.m_iNumberStatus == 4) {
                    this.m_jPor.setText("x");
                    this.m_iNumberStatus = 1;
                } else if (cTrans == '.' && this.m_iNumberStatus == 6 && !this.priceWith00.booleanValue()) {
                    this.m_jPor.setText(this.m_jPor.getText() + ".");
                    this.m_iNumberStatus = 7;
                } else if (cTrans == '.' && this.m_iNumberStatus == 6) {
                    this.m_jPor.setText(this.m_jPor.getText() + "00");
                    this.m_iNumberStatus = 1;
                } else if (cTrans == '0' && (this.m_iNumberStatus == 5 || this.m_iNumberStatus == 7)) {
                    this.m_jPor.setText(this.m_jPor.getText() + cTrans);
                } else if (!(cTrans != '1' && cTrans != '2' && cTrans != '3' && cTrans != '4' && cTrans != '5' && cTrans != '6' && cTrans != '7' && cTrans != '8' && cTrans != '9' || this.m_iNumberStatus != 5 && this.m_iNumberStatus != 7)) {
                    this.m_jPor.setText(this.m_jPor.getText() + cTrans);
                    this.m_iNumberStatus = 7;
                    this.m_iNumberStatusPor = 1;
                } else if (cTrans == '\u00a7' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0) {
                    if (this.m_App.getDeviceScale().existsScale() && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                        try {
                            Double value = this.m_App.getDeviceScale().readWeight();
                            if (value != null) {
                                ProductInfoExt product = this.getInputProduct();
                                this.addTicketLine(product, value, product.getPriceSell());
                            }
                        }
                        catch (ScaleException e) {
                            Toolkit.getDefaultToolkit().beep();
                            new MessageInf(-33554432, AppLocal.getIntString("message.noweight"), e).show(this);
                            this.stateToZero();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (cTrans == '\u00a7' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0) {
                    int i = this.m_ticketlines.getSelectedIndex();
                    if (i < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (this.m_App.getDeviceScale().existsScale()) {
                        try {
                            Double value = this.m_App.getDeviceScale().readWeight();
                            if (value != null) {
                                TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                                newline.setMultiply(value);
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            }
                        }
                        catch (ScaleException e) {
                            Toolkit.getDefaultToolkit().beep();
                            new MessageInf(-33554432, AppLocal.getIntString("message.noweight"), e).show(this);
                            this.stateToZero();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (cTrans == '+' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0) {
                    int i = this.m_ticketlines.getSelectedIndex();
                    if (i < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                        if (this.m_oTicket.getTicketType() == 1) {
                            if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                                this.oCount = this.count - 1;
                                this.pinOK = false;
                                this.changeCount(this.pinOK);
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                newline.setProperty("ticket.updated", "true");
                                this.paintTicketLine(i, newline);
                            } else {
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                newline.setProperty("ticket.updated", "true");
                                this.paintTicketLine(i, newline);
                            }
                        } else if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                            this.oCount = this.count + 1;
                            this.pinOK = false;
                            if (this.changeCount(this.pinOK)) {
                                newline.setMultiply(newline.getMultiply() + 1.0);
                                newline.setProperty("ticket.updated", "true");
                                this.paintTicketLine(i, newline);
                            }
                        } else {
                            newline.setMultiply(newline.getMultiply() + 1.0);
                            newline.setProperty("ticket.updated", "true");
                            this.paintTicketLine(i, newline);
                        }
                    }
                } else if (cTrans == '-' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 0 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                    int i = this.m_ticketlines.getSelectedIndex();
                    if (i < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                        if (this.m_oTicket.getTicketType() == 1) {
                            if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                                this.oCount = this.count - 1;
                                this.pinOK = false;
                                this.changeCount(this.pinOK);
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                newline.setProperty("ticket.updated", "true");
                                this.paintTicketLine(i, newline);
                            } else {
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                newline.setProperty("ticket.updated", "true");
                                this.paintTicketLine(i, newline);
                            }
                            if (newline.getMultiply() >= 0.0) {
                                this.removeTicketLine(i);
                            } else {
                                this.paintTicketLine(i, newline);
                            }
                        } else {
                            if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                                this.oCount = this.count - 1;
                                this.pinOK = false;
                                if (this.changeCount(this.pinOK)) {
                                    newline.setMultiply(newline.getMultiply() - 1.0);
                                    newline.setProperty("ticket.updated", "true");
                                    this.paintTicketLine(i, newline);
                                }
                            } else {
                                newline.setMultiply(newline.getMultiply() - 1.0);
                                newline.setProperty("ticket.updated", "true");
                                this.paintTicketLine(i, newline);
                            }
                            if (newline.getMultiply() <= 0.0) {
                                this.removeTicketLine(i);
                            } else {
                                this.paintTicketLine(i, newline);
                            }
                        }
                    }
                } else if (cTrans == '+' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 1) {
                    int i = this.m_ticketlines.getSelectedIndex();
                    if (i < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        double dPor = this.getPorValue();
                        TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                        if (this.m_oTicket.getTicketType() == 1) {
                            if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                                this.oCount = this.count - 1;
                                this.pinOK = false;
                                this.changeCount(this.pinOK);
                                newline.setMultiply(-dPor);
                                newline.setProperty("ticket.updated", "true");
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            } else {
                                newline.setMultiply(-dPor);
                                newline.setProperty("ticket.updated", "true");
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            }
                        } else if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                            this.oCount = this.count + 1;
                            this.pinOK = false;
                            if (this.changeCount(this.pinOK)) {
                                newline.setMultiply(dPor);
                                newline.setProperty("ticket.updated", "true");
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            }
                        } else {
                            newline.setMultiply(dPor);
                            newline.setProperty("ticket.updated", "true");
                            newline.setPrice(Math.abs(newline.getPrice()));
                            this.paintTicketLine(i, newline);
                        }
                    }
                } else if (cTrans == '-' && this.m_iNumberStatusInput == 0 && this.m_iNumberStatusPor == 1 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                    int i = this.m_ticketlines.getSelectedIndex();
                    if (i < 0) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        double dPor = this.getPorValue();
                        TicketLineInfo newline = new TicketLineInfo(this.m_oTicket.getLine(i));
                        if (this.m_oTicket.getTicketType() == 1) {
                            if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                                this.oCount = this.count - 1;
                                this.pinOK = false;
                                this.changeCount(this.pinOK);
                                newline.setMultiply(-dPor);
                                newline.setProperty("ticket.updated", "true");
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            } else {
                                newline.setMultiply(-dPor);
                                newline.setProperty("ticket.updated", "true");
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            }
                        } else if (this.m_App.getProperties().getProperty("override.check").equals("true")) {
                            this.oCount = this.count - 1;
                            this.pinOK = false;
                            if (this.changeCount(this.pinOK)) {
                                newline.setMultiply(dPor);
                                newline.setProperty("ticket.updated", "true");
                                newline.setPrice(Math.abs(newline.getPrice()));
                                this.paintTicketLine(i, newline);
                            }
                        } else {
                            newline.setMultiply(dPor);
                            newline.setProperty("ticket.updated", "true");
                            newline.setPrice(Math.abs(newline.getPrice()));
                            this.paintTicketLine(i, newline);
                        }
                    }
                } else if (cTrans == '+' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                    ProductInfoExt product = this.getInputProduct();
                    this.addTicketLine(product, 1.0, product.getPriceSell());
                    this.m_jEditLine.doClick();
                } else if (cTrans == '-' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 0 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                    ProductInfoExt product = this.getInputProduct();
                    this.addTicketLine(product, 1.0, -product.getPriceSell());
                    this.m_jEditLine.doClick();
                } else if (cTrans == '+' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 1 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                    ProductInfoExt product = this.getInputProduct();
                    this.addTicketLine(product, this.getPorValue(), product.getPriceSell());
                } else if (cTrans == '-' && this.m_iNumberStatusInput == 1 && this.m_iNumberStatusPor == 1 && this.m_App.getAppUserView().getUser().hasPermission("sales.EditLines")) {
                    ProductInfoExt product = this.getInputProduct();
                    this.addTicketLine(product, this.getPorValue(), -product.getPriceSell());
                } else if (cTrans == ' ' || cTrans == '=') {
                    if (this.m_oTicket.getLinesCount() > 0) {
                        if (this.closeTicket(this.m_oTicket, this.m_oTicketExt)) {
                            this.m_ticketsbag.deleteTicket();
                            String autoLogoff = this.m_App.getProperties().getProperty("till.autoLogoff");
                            if (autoLogoff != null && autoLogoff.equals("true")) {
                                if ("restaurant".equals(this.m_App.getProperties().getProperty("machine.ticketsbag")) && "true".equals(this.m_App.getProperties().getProperty("till.autoLogoffrestaurant"))) {
                                    this.deactivate();
                                    this.setActiveTicket(null, null);
                                } else {
                                    ((JRootApp)this.m_App).closeAppView();
                                }
                            }
                        } else {
                            this.refreshTicket();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }
    }

    private boolean closeTicket(TicketInfo ticket, Object ticketext) {
        if (this.listener != null) {
            this.listener.stop();
        }
        boolean resultok = false;
        if (this.m_App.getAppUserView().getUser().hasPermission("sales.Total")) {
            block10: {
                this.warrantyCheck(ticket);
                try {
                    this.taxeslogic.calculateTaxes(ticket);
                    if (ticket.getTotal() >= 0.0) {
                        ticket.resetPayments();
                    }
                    if (this.executeEvent(ticket, ticketext, "ticket.total", new ScriptArg[0]) != null) break block10;
                    if (this.listener != null) {
                        this.listener.stop();
                    }
                    this.printTicket("Printer.TicketTotal", ticket, ticketext);
                    JPaymentSelect paymentdialog = ticket.getTicketType() == 0 ? this.paymentdialogreceipt : this.paymentdialogrefund;
                    paymentdialog.setPrintSelected("true".equals(this.m_jbtnconfig.getProperty("printselected", "true")));
                    paymentdialog.setTransactionID(ticket.getTransactionID());
                    if (!paymentdialog.showDialog(ticket.getTotal(), ticket.getCustomer())) break block10;
                    ticket.setPayments(paymentdialog.getSelectedPayments());
                    ticket.setUser(this.m_App.getAppUserView().getUser().getUserInfo());
                    ticket.setActiveCash(this.m_App.getActiveCashIndex());
                    ticket.setDate(new Date());
                    if (this.executeEvent(ticket, ticketext, "ticket.save", new ScriptArg[0]) != null) break block10;
                    try {
                        this.dlSales.saveTicket(ticket, this.m_App.getInventoryLocation());
                        this.m_config.setProperty("lastticket.number", Integer.toString(ticket.getTicketId()));
                        this.m_config.setProperty("lastticket.type", Integer.toString(ticket.getTicketType()));
                        this.m_config.save();
                    }
                    catch (BasicException eData) {
                        MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.nosaveticket"), eData);
                        msg.show(this);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.executeEvent(ticket, ticketext, "ticket.close", new ScriptArg("print", paymentdialog.isPrintSelected()));
                    this.printTicket(paymentdialog.isPrintSelected() || this.warrantyPrint != false ? "Printer.Ticket" : "Printer.Ticket2", ticket, ticketext);
                    this.Notify(AppLocal.getIntString("notify.printing"));
                    resultok = true;
                    if ("restaurant".equals(this.m_App.getProperties().getProperty("machine.ticketsbag")) && !ticket.getOldTicket()) {
                        this.restDB.clearCustomerNameInTable(ticketext.toString());
                        this.restDB.clearWaiterNameInTable(ticketext.toString());
                        this.restDB.clearTicketIdInTable(ticketext.toString());
                    }
                }
                catch (TaxesException e) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotcalculatetaxes"));
                    msg.show(this);
                    resultok = false;
                }
            }
            this.m_oTicket.resetTaxes();
            this.m_oTicket.resetPayments();
            this.jCheckStock.setText("");
        }
        return resultok;
    }

    private boolean warrantyCheck(TicketInfo ticket) {
        this.warrantyPrint = false;
        for (int lines = 0; lines < ticket.getLinesCount(); ++lines) {
            if (this.warrantyPrint.booleanValue()) continue;
            this.warrantyPrint = ticket.getLine(lines).isProductWarranty();
            return true;
        }
        return false;
    }

    public String getPickupString(TicketInfo pTicket) {
        if (pTicket == null) {
            return "0";
        }
        String tmpPickupId = Integer.toString(pTicket.getPickupId());
        String pickupSize = this.m_App.getProperties().getProperty("till.pickupsize");
        if (pickupSize != null && Integer.parseInt(pickupSize) >= tmpPickupId.length()) {
            while (tmpPickupId.length() < Integer.parseInt(pickupSize)) {
                tmpPickupId = "0" + tmpPickupId;
            }
        }
        return tmpPickupId;
    }

    private void printTicket(String sresourcename, TicketInfo ticket, Object ticketext) {
        String sresource = this.dlSystem.getResourceAsXML(sresourcename);
        if (sresource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            if (ticket.getPickupId() == 0) {
                try {
                    ticket.setPickupId(this.dlSales.getNextPickupIndex());
                }
                catch (BasicException e) {
                    ticket.setPickupId(0);
                }
            }
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                if (Boolean.parseBoolean(this.m_App.getProperties().getProperty("receipt.newlayout"))) {
                    script.put("taxes", ticket.getTaxLines());
                } else {
                    script.put("taxes", this.taxcollection);
                }
                script.put("taxeslogic", this.taxeslogic);
                script.put("ticket", ticket);
                script.put("place", ticketext);
                script.put("warranty", this.warrantyPrint);
                script.put("pickupid", this.getPickupString(ticket));
                this.refreshTicket();
                this.m_TTP.printTicket(script.eval(sresource).toString(), ticket);
            }
            catch (TicketPrinterException | ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), e);
                msg.show(this);
            }
        }
    }

    public void printTicket(String resource) {
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"));
            msg.show(this);
        } else {
            this.printTicket(resource, this.m_oTicket, this.m_oTicketExt);
        }
        this.Notify(AppLocal.getIntString("notify.printed"));
        this.j_btnRemotePrt.setEnabled(false);
    }

    public void customerAdd(String resource) {
        this.Notify(AppLocal.getIntString("notify.customeradd"));
    }

    public void customerRemove(String resource) {
        this.Notify(AppLocal.getIntString("notify.customerremove"));
    }

    public void customerChange(String resource) {
        this.Notify(AppLocal.getIntString("notify.customerchange"));
    }

    public void Notify(String msg) {
        WebNotification notification = new WebNotification();
        notification.setIcon(NotificationIcon.information);
        notification.setDisplayTime(4000L);
        WebClock clock = new WebClock();
        clock.setClockType(ClockType.timer);
        clock.setTimeLeft(5000L);
        notification.setContent(msg);
        NotificationManager.showNotification((WebNotification)notification);
        clock.start();
    }

    private void printReport(String resourcefile, TicketInfo ticket, Object ticketext) {
        try {
            JasperReport jr;
            InputStream in = this.getClass().getResourceAsStream(resourcefile + ".ser");
            if (in == null) {
                JasperDesign jd = JRXmlLoader.load((InputStream)this.getClass().getResourceAsStream(resourcefile + ".jrxml"));
                jr = JasperCompileManager.compileReport((JasperDesign)jd);
            } else {
                try (ObjectInputStream oin = new ObjectInputStream(in);){
                    jr = (JasperReport)oin.readObject();
                }
            }
            HashMap<String, Object> reportparams = new HashMap<String, Object>();
            try {
                reportparams.put("REPORT_RESOURCE_BUNDLE", ResourceBundle.getBundle(resourcefile + ".properties"));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            reportparams.put("TAXESLOGIC", this.taxeslogic);
            HashMap<String, Object> reportfields = new HashMap<String, Object>();
            reportfields.put("TICKET", ticket);
            reportfields.put("PLACE", ticketext);
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, reportparams, (JRDataSource)new JRMapArrayDataSource(new Object[]{reportfields}));
            PrintService service = ReportUtils.getPrintService(this.m_App.getProperties().getProperty("machine.printername"));
            JRPrinterAWT300.printPages(jp, 0, jp.getPages().size() - 1, service);
        }
        catch (IOException | ClassNotFoundException | JRException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadreport"), e);
            msg.show(this);
        }
    }

    private void visorTicketLine(TicketLineInfo oLine) {
        if (oLine == null) {
            this.m_App.getDeviceTicket().getDeviceDisplay().clearVisor();
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("ticketline", oLine);
                this.m_TTP.printTicket(script.eval(this.dlSystem.getResourceAsXML("Printer.TicketLine")).toString());
            }
            catch (TicketPrinterException | ScriptException e) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintline"), e);
                msg.show(this);
            }
        }
    }

    private Object evalScript(ScriptObject scr, String resource, ScriptArg ... args) {
        try {
            scr.setSelectedIndex(this.m_ticketlines.getSelectedIndex());
            return scr.evalScript(this.dlSystem.getResourceAsXML(resource), args);
        }
        catch (ScriptException e) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"), e);
            msg.show(this);
            return msg;
        }
    }

    public void evalScriptAndRefresh(String resource, ScriptArg ... args) {
        if (resource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"));
            msg.show(this);
        } else {
            ScriptObject scr = new ScriptObject(this.m_oTicket, this.m_oTicketExt);
            scr.setSelectedIndex(this.m_ticketlines.getSelectedIndex());
            this.evalScript(scr, resource, args);
            this.refreshTicket();
            this.setSelectedIndex(scr.getSelectedIndex());
        }
    }

    private Object executeEventAndRefresh(String eventkey, ScriptArg ... args) {
        String resource = this.m_jbtnconfig.getEvent(eventkey);
        if (resource == null) {
            return null;
        }
        ScriptObject scr = new ScriptObject(this.m_oTicket, this.m_oTicketExt);
        scr.setSelectedIndex(this.m_ticketlines.getSelectedIndex());
        Object result = this.evalScript(scr, resource, args);
        this.refreshTicket();
        this.setSelectedIndex(scr.getSelectedIndex());
        return result;
    }

    private Object executeEvent(TicketInfo ticket, Object ticketext, String eventkey, ScriptArg ... args) {
        String resource = this.m_jbtnconfig.getEvent(eventkey);
        if (resource == null) {
            return null;
        }
        ScriptObject scr = new ScriptObject(ticket, ticketext);
        return this.evalScript(scr, resource, args);
    }

    public String getResourceAsXML(String sresourcename) {
        return this.dlSystem.getResourceAsXML(sresourcename);
    }

    public BufferedImage getResourceAsImage(String sresourcename) {
        return this.dlSystem.getResourceAsImage(sresourcename);
    }

    private void setSelectedIndex(int i) {
        if (i >= 0 && i < this.m_oTicket.getLinesCount()) {
            this.m_ticketlines.setSelectedIndex(i);
        } else if (this.m_oTicket.getLinesCount() > 0) {
            this.m_ticketlines.setSelectedIndex(this.m_oTicket.getLinesCount() - 1);
        }
    }

    private String setTempjPrice(String jPrice) {
        jPrice = jPrice.replace(".", "");
        long tempL = Long.parseLong(jPrice);
        jPrice = Long.toString(tempL);
        while (jPrice.length() < 3) {
            jPrice = "0" + jPrice;
        }
        return jPrice.length() <= 2 ? jPrice : new StringBuffer(jPrice).insert(jPrice.length() - 2, ".").toString();
    }

    public void checkStock() {
        int i = this.m_ticketlines.getSelectedIndex();
        if (i >= 0) {
            try {
                TicketLineInfo line = this.m_oTicket.getLine(i);
                String pId = line.getProductID();
                String lName = this.m_App.getProperties().getProperty("machine.department");
                lName = "'" + lName + "'";
                String location = this.m_App.getInventoryLocation();
                ProductStock checkProduct = this.dlSales.getProductStockState(pId, location);
                if (checkProduct != null) {
                    if (checkProduct.getUnits() <= 0.0) {
                        this.jCheckStock.setForeground(Color.magenta);
                    } else {
                        this.jCheckStock.setForeground(Color.darkGray);
                    }
                    double dUnits = checkProduct.getUnits();
                    int iUnits = (int)dUnits;
                    this.jCheckStock.setText(Integer.toString(iUnits));
                } else {
                    this.jCheckStock.setText(null);
                }
            }
            catch (BasicException ex) {
                Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void checkCustomer() {
        if (this.m_oTicket.getCustomer().isVIP()) {
            String vip = this.m_oTicket.getCustomer().isVIP() ? AppLocal.getIntString("message.vipyes") : AppLocal.getIntString("message.vipno");
            String discount = this.m_oTicket.getCustomer().getDiscount() > 0.0 ? AppLocal.getIntString("message.discyes") + this.m_oTicket.getCustomer().getDiscount() + "%" : AppLocal.getIntString("message.discno");
            String content = "<html><b>" + AppLocal.getIntString("label.vip") + " : </b>" + vip + "<br><b>" + AppLocal.getIntString("label.discount") + " : </b>" + discount + "<br>";
            JFrame frame = new JFrame();
            JOptionPane.showMessageDialog(frame, content, "Info", 2);
        }
    }

    private void initComponents() {
        this.m_jPanContainer = new JPanel();
        this.m_jOptions = new JPanel();
        this.m_jPanelBag = new JPanel();
        this.jTBtnShow = new JToggleButton();
        this.m_jbtnScale = new JButton();
        this.jbtnMooring = new JButton();
        this.m_jButtons = new JPanel();
        this.btnSplit = new JButton();
        this.btnReprint1 = new JButton();
        this.j_btnRemotePrt = new JButton();
        this.jBtnCustomer = new JButton();
        this.m_jPanelScripts = new JPanel();
        this.m_jButtonsExt = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_jPanTicket = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jDelete = new JButton();
        this.m_jList = new JButton();
        this.m_jEditLine = new JButton();
        this.jEditAttributes = new JButton();
        this.jCheckStock = new JButton();
        this.m_jPanelCentral = new JPanel();
        this.jPanel4 = new JPanel();
        this.filler2 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.m_jTicketId = new JLabel();
        this.m_jPanTotals = new JPanel();
        this.m_jLblTotalEuros3 = new JLabel();
        this.m_jLblTotalEuros2 = new JLabel();
        this.m_jLblTotalEuros1 = new JLabel();
        this.m_jSubtotalEuros = new JLabel();
        this.m_jTaxesEuros = new JLabel();
        this.m_jTotalEuros = new JLabel();
        this.m_jContEntries = new JPanel();
        this.m_jPanEntries = new JPanel();
        this.jPanel9 = new JPanel();
        this.m_jaddtax = new WebSwitch();
        this.m_jPrice = new JLabel();
        this.m_jPor = new JLabel();
        this.m_jEnter = new JButton();
        this.m_jTax = new JComboBox();
        this.m_jKeyFactory = new JTextField();
        this.m_jNumberKeys = new JNumberKeys();
        this.catcontainer = new JPanel();
        this.setBackground(new Color(255, 204, 153));
        this.setOpaque(false);
        this.setLayout(new CardLayout());
        this.m_jPanContainer.setLayout(new BorderLayout());
        this.m_jOptions.setLayout(new BorderLayout());
        this.m_jPanelBag.setAutoscrolls(true);
        this.m_jPanelBag.setMaximumSize(new Dimension(10, 10));
        this.m_jPanelBag.setPreferredSize(new Dimension(0, 60));
        this.jTBtnShow.setFont(new Font("Arial", 0, 14));
        this.jTBtnShow.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/resources.png")));
        this.jTBtnShow.setPreferredSize(new Dimension(80, 45));
        this.jTBtnShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.jTBtnShowActionPerformed(evt);
            }
        });
        this.m_jPanelBag.add(this.jTBtnShow);
        this.m_jbtnScale.setFont(new Font("Arial", 0, 12));
        this.m_jbtnScale.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/scale.png")));
        this.m_jbtnScale.setText(AppLocal.getIntString("button.scale"));
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.m_jbtnScale.setToolTipText(bundle.getString("tooltip.scale"));
        this.m_jbtnScale.setFocusPainted(false);
        this.m_jbtnScale.setFocusable(false);
        this.m_jbtnScale.setMargin(new Insets(8, 14, 8, 14));
        this.m_jbtnScale.setMaximumSize(new Dimension(85, 44));
        this.m_jbtnScale.setMinimumSize(new Dimension(85, 44));
        this.m_jbtnScale.setPreferredSize(new Dimension(85, 45));
        this.m_jbtnScale.setRequestFocusEnabled(false);
        this.m_jbtnScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.m_jbtnScaleActionPerformed(evt);
            }
        });
        this.m_jPanelBag.add(this.m_jbtnScale);
        this.jbtnMooring.setFont(new Font("Arial", 0, 12));
        this.jbtnMooring.setText(bundle.getString("button.moorings"));
        this.jbtnMooring.setMargin(new Insets(8, 14, 8, 14));
        this.jbtnMooring.setMaximumSize(new Dimension(80, 40));
        this.jbtnMooring.setMinimumSize(new Dimension(80, 40));
        this.jbtnMooring.setPreferredSize(new Dimension(80, 45));
        this.jbtnMooring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.jbtnMooringActionPerformed(evt);
            }
        });
        this.m_jPanelBag.add(this.jbtnMooring);
        this.m_jButtons.setPreferredSize(new Dimension(350, 55));
        this.btnSplit.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/sale_split_sml.png")));
        this.btnSplit.setToolTipText(bundle.getString("tooltip.salesplit"));
        this.btnSplit.setEnabled(false);
        this.btnSplit.setFocusPainted(false);
        this.btnSplit.setFocusable(false);
        this.btnSplit.setMargin(new Insets(8, 14, 8, 14));
        this.btnSplit.setMaximumSize(new Dimension(50, 40));
        this.btnSplit.setMinimumSize(new Dimension(50, 40));
        this.btnSplit.setPreferredSize(new Dimension(80, 45));
        this.btnSplit.setRequestFocusEnabled(false);
        this.btnSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.btnSplitActionPerformed(evt);
            }
        });
        this.btnReprint1.setFont(new Font("Arial", 0, 12));
        this.btnReprint1.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/reprint24.png")));
        this.btnReprint1.setToolTipText(bundle.getString("tooltip.reprintLastTicket"));
        this.btnReprint1.setFocusPainted(false);
        this.btnReprint1.setFocusable(false);
        this.btnReprint1.setMargin(new Insets(8, 14, 8, 14));
        this.btnReprint1.setMaximumSize(new Dimension(50, 40));
        this.btnReprint1.setMinimumSize(new Dimension(50, 40));
        this.btnReprint1.setPreferredSize(new Dimension(80, 45));
        this.btnReprint1.setRequestFocusEnabled(false);
        this.btnReprint1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.btnReprint1ActionPerformed(evt);
            }
        });
        this.j_btnRemotePrt.setFont(new Font("Tahoma", 0, 12));
        this.j_btnRemotePrt.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/remote_print.png")));
        this.j_btnRemotePrt.setText(bundle.getString("button.sendorder"));
        this.j_btnRemotePrt.setToolTipText(bundle.getString("tooltip.printtoremote"));
        this.j_btnRemotePrt.setMargin(new Insets(0, 4, 0, 4));
        this.j_btnRemotePrt.setMaximumSize(new Dimension(50, 40));
        this.j_btnRemotePrt.setMinimumSize(new Dimension(50, 40));
        this.j_btnRemotePrt.setPreferredSize(new Dimension(80, 45));
        this.j_btnRemotePrt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.j_btnRemotePrtActionPerformed(evt);
            }
        });
        this.jBtnCustomer.setFont(new Font("Arial", 0, 14));
        this.jBtnCustomer.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/customer.png")));
        this.jBtnCustomer.setToolTipText(bundle.getString("tooltip.salescustomer"));
        this.jBtnCustomer.setPreferredSize(new Dimension(80, 45));
        this.jBtnCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.jBtnCustomerActionPerformed(evt);
            }
        });
        GroupLayout m_jButtonsLayout = new GroupLayout(this.m_jButtons);
        this.m_jButtons.setLayout(m_jButtonsLayout);
        m_jButtonsLayout.setHorizontalGroup(m_jButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(m_jButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.jBtnCustomer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSplit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.j_btnRemotePrt, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReprint1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        m_jButtonsLayout.setVerticalGroup(m_jButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(m_jButtonsLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(m_jButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.j_btnRemotePrt, -1, -1, Short.MAX_VALUE).addComponent(this.btnSplit, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnReprint1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jBtnCustomer, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.m_jPanelBag.add(this.m_jButtons);
        this.m_jOptions.add((Component)this.m_jPanelBag, "First");
        this.m_jPanelScripts.setPreferredSize(new Dimension(200, 60));
        this.m_jPanelScripts.setLayout(new BorderLayout());
        this.m_jButtonsExt.setPreferredSize(new Dimension(20, 60));
        this.jPanel1.setMinimumSize(new Dimension(235, 50));
        this.jPanel1.setPreferredSize(new Dimension(10, 55));
        this.m_jButtonsExt.add(this.jPanel1);
        this.m_jPanelScripts.add((Component)this.m_jButtonsExt, "First");
        this.m_jOptions.add((Component)this.m_jPanelScripts, "Center");
        this.m_jPanelScripts.getAccessibleContext().setAccessibleDescription("");
        this.m_jPanContainer.add((Component)this.m_jOptions, "North");
        this.m_jPanTicket.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jPanTicket.setLayout(new BorderLayout());
        this.jPanel5.setFont(new Font("Arial", 0, 12));
        this.jPanel5.setPreferredSize(new Dimension(75, 270));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanel2.setPreferredSize(new Dimension(70, 250));
        this.jPanel2.setLayout(new GridLayout(0, 1, 5, 5));
        this.m_jDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/editdelete.png")));
        this.m_jDelete.setToolTipText(bundle.getString("tooltip.saleremoveline"));
        this.m_jDelete.setFocusPainted(false);
        this.m_jDelete.setFocusable(false);
        this.m_jDelete.setMargin(new Insets(8, 14, 8, 14));
        this.m_jDelete.setMaximumSize(new Dimension(42, 36));
        this.m_jDelete.setMinimumSize(new Dimension(42, 36));
        this.m_jDelete.setPreferredSize(new Dimension(50, 45));
        this.m_jDelete.setRequestFocusEnabled(false);
        this.m_jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.m_jDeleteActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jDelete);
        this.m_jList.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/search32.png")));
        this.m_jList.setToolTipText(bundle.getString("tooltip.saleproductfind"));
        this.m_jList.setFocusPainted(false);
        this.m_jList.setFocusable(false);
        this.m_jList.setMargin(new Insets(8, 14, 8, 14));
        this.m_jList.setMaximumSize(new Dimension(42, 36));
        this.m_jList.setMinimumSize(new Dimension(42, 36));
        this.m_jList.setPreferredSize(new Dimension(50, 45));
        this.m_jList.setRequestFocusEnabled(false);
        this.m_jList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.m_jListActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jList);
        this.m_jEditLine.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/sale_editline.png")));
        this.m_jEditLine.setToolTipText(bundle.getString("tooltip.saleeditline"));
        this.m_jEditLine.setFocusPainted(false);
        this.m_jEditLine.setFocusable(false);
        this.m_jEditLine.setMargin(new Insets(8, 14, 8, 14));
        this.m_jEditLine.setMaximumSize(new Dimension(42, 36));
        this.m_jEditLine.setMinimumSize(new Dimension(42, 36));
        this.m_jEditLine.setPreferredSize(new Dimension(50, 45));
        this.m_jEditLine.setRequestFocusEnabled(false);
        this.m_jEditLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.m_jEditLineActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.m_jEditLine);
        this.jEditAttributes.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/attributes.png")));
        this.jEditAttributes.setToolTipText(bundle.getString("tooltip.saleattributes"));
        this.jEditAttributes.setFocusPainted(false);
        this.jEditAttributes.setFocusable(false);
        this.jEditAttributes.setMargin(new Insets(8, 14, 8, 14));
        this.jEditAttributes.setMaximumSize(new Dimension(42, 36));
        this.jEditAttributes.setMinimumSize(new Dimension(42, 36));
        this.jEditAttributes.setPreferredSize(new Dimension(50, 45));
        this.jEditAttributes.setRequestFocusEnabled(false);
        this.jEditAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.jEditAttributesActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jEditAttributes);
        this.jCheckStock.setFont(new Font("Arial", 1, 14));
        this.jCheckStock.setForeground(new Color(76, 197, 237));
        this.jCheckStock.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/info.png")));
        this.jCheckStock.setToolTipText(bundle.getString("tooltip.salecheckstock"));
        this.jCheckStock.setFocusPainted(false);
        this.jCheckStock.setFocusable(false);
        this.jCheckStock.setHorizontalAlignment(4);
        this.jCheckStock.setHorizontalTextPosition(2);
        this.jCheckStock.setMargin(new Insets(8, 4, 8, 4));
        this.jCheckStock.setMaximumSize(new Dimension(42, 36));
        this.jCheckStock.setMinimumSize(new Dimension(42, 36));
        this.jCheckStock.setPreferredSize(new Dimension(80, 45));
        this.jCheckStock.setRequestFocusEnabled(false);
        this.jCheckStock.setVerticalTextPosition(1);
        this.jCheckStock.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelTicket.this.jCheckStockMouseClicked(evt);
            }
        });
        this.jCheckStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.jCheckStockActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jCheckStock);
        this.jPanel5.add((Component)this.jPanel2, "North");
        this.m_jPanTicket.add((Component)this.jPanel5, "Before");
        this.m_jPanelCentral.setFont(new Font("Arial", 0, 14));
        this.m_jPanelCentral.setPreferredSize(new Dimension(450, 240));
        this.m_jPanelCentral.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.add((Component)this.filler2, "Before");
        this.m_jTicketId.setFont(new Font("Arial", 1, 12));
        this.m_jTicketId.setHorizontalAlignment(2);
        this.m_jTicketId.setVerticalAlignment(1);
        this.m_jTicketId.setOpaque(true);
        this.m_jTicketId.setPreferredSize(new Dimension(300, 40));
        this.m_jTicketId.setRequestFocusEnabled(false);
        this.m_jTicketId.setVerticalTextPosition(1);
        this.jPanel4.add((Component)this.m_jTicketId, "Center");
        this.m_jPanTotals.setPreferredSize(new Dimension(375, 60));
        this.m_jPanTotals.setLayout(new GridLayout(2, 3, 4, 0));
        this.m_jLblTotalEuros3.setFont(new Font("Arial", 1, 14));
        this.m_jLblTotalEuros3.setHorizontalAlignment(0);
        this.m_jLblTotalEuros3.setLabelFor(this.m_jSubtotalEuros);
        this.m_jLblTotalEuros3.setText(AppLocal.getIntString("label.subtotalcash"));
        this.m_jPanTotals.add(this.m_jLblTotalEuros3);
        this.m_jLblTotalEuros2.setFont(new Font("Arial", 1, 14));
        this.m_jLblTotalEuros2.setHorizontalAlignment(0);
        this.m_jLblTotalEuros2.setLabelFor(this.m_jSubtotalEuros);
        this.m_jLblTotalEuros2.setText(AppLocal.getIntString("label.taxcash"));
        this.m_jPanTotals.add(this.m_jLblTotalEuros2);
        this.m_jLblTotalEuros1.setFont(new Font("Arial", 1, 14));
        this.m_jLblTotalEuros1.setHorizontalAlignment(0);
        this.m_jLblTotalEuros1.setLabelFor(this.m_jTotalEuros);
        this.m_jLblTotalEuros1.setText(AppLocal.getIntString("label.totalcash"));
        this.m_jPanTotals.add(this.m_jLblTotalEuros1);
        this.m_jSubtotalEuros.setBackground(this.m_jEditLine.getBackground());
        this.m_jSubtotalEuros.setFont(new Font("Arial", 0, 18));
        this.m_jSubtotalEuros.setForeground(this.m_jEditLine.getForeground());
        this.m_jSubtotalEuros.setHorizontalAlignment(0);
        this.m_jSubtotalEuros.setLabelFor(this.m_jSubtotalEuros);
        this.m_jSubtotalEuros.setToolTipText(bundle.getString("tooltip.salesubtotal"));
        this.m_jSubtotalEuros.setBorder(new LineBorder(new Color(153, 153, 153), 1, true));
        this.m_jSubtotalEuros.setMaximumSize(new Dimension(125, 25));
        this.m_jSubtotalEuros.setMinimumSize(new Dimension(80, 25));
        this.m_jSubtotalEuros.setPreferredSize(new Dimension(80, 25));
        this.m_jSubtotalEuros.setRequestFocusEnabled(false);
        this.m_jPanTotals.add(this.m_jSubtotalEuros);
        this.m_jTaxesEuros.setBackground(this.m_jEditLine.getBackground());
        this.m_jTaxesEuros.setFont(new Font("Arial", 0, 18));
        this.m_jTaxesEuros.setForeground(this.m_jEditLine.getForeground());
        this.m_jTaxesEuros.setHorizontalAlignment(0);
        this.m_jTaxesEuros.setLabelFor(this.m_jTaxesEuros);
        this.m_jTaxesEuros.setToolTipText(bundle.getString("tooltip.saletax"));
        this.m_jTaxesEuros.setBorder(new LineBorder(new Color(153, 153, 153), 1, true));
        this.m_jTaxesEuros.setMaximumSize(new Dimension(125, 25));
        this.m_jTaxesEuros.setMinimumSize(new Dimension(80, 25));
        this.m_jTaxesEuros.setPreferredSize(new Dimension(80, 25));
        this.m_jTaxesEuros.setRequestFocusEnabled(false);
        this.m_jPanTotals.add(this.m_jTaxesEuros);
        this.m_jTotalEuros.setBackground(this.m_jEditLine.getBackground());
        this.m_jTotalEuros.setFont(new Font("Arial", 1, 18));
        this.m_jTotalEuros.setForeground(this.m_jEditLine.getForeground());
        this.m_jTotalEuros.setHorizontalAlignment(0);
        this.m_jTotalEuros.setLabelFor(this.m_jTotalEuros);
        this.m_jTotalEuros.setToolTipText(bundle.getString("tooltip.saletotal"));
        this.m_jTotalEuros.setBorder(new LineBorder(new Color(153, 153, 153), 1, true));
        this.m_jTotalEuros.setMaximumSize(new Dimension(125, 25));
        this.m_jTotalEuros.setMinimumSize(new Dimension(80, 25));
        this.m_jTotalEuros.setPreferredSize(new Dimension(100, 25));
        this.m_jTotalEuros.setRequestFocusEnabled(false);
        this.m_jPanTotals.add(this.m_jTotalEuros);
        this.jPanel4.add((Component)this.m_jPanTotals, "After");
        this.m_jPanelCentral.add((Component)this.jPanel4, "South");
        this.m_jPanTicket.add((Component)this.m_jPanelCentral, "Center");
        this.m_jPanContainer.add((Component)this.m_jPanTicket, "Center");
        this.m_jContEntries.setFont(new Font("Arial", 0, 12));
        this.m_jContEntries.setMinimumSize(new Dimension(300, 350));
        this.m_jContEntries.setLayout(new BorderLayout());
        this.m_jPanEntries.setPreferredSize(new Dimension(300, 350));
        this.m_jPanEntries.setLayout(new BoxLayout(this.m_jPanEntries, 1));
        this.jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jaddtax.setBorder(null);
        this.m_jaddtax.setToolTipText(bundle.getString("tooltip.switchtax"));
        this.m_jaddtax.setFont(new Font("Arial", 0, 14));
        this.m_jaddtax.setPreferredSize(new Dimension(60, 30));
        this.m_jaddtax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.m_jaddtaxActionPerformed(evt);
            }
        });
        this.m_jPrice.setFont(new Font("Arial", 1, 16));
        this.m_jPrice.setForeground(new Color(76, 197, 237));
        this.m_jPrice.setHorizontalAlignment(2);
        this.m_jPrice.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(76, 197, 237)), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jPrice.setOpaque(true);
        this.m_jPrice.setPreferredSize(new Dimension(100, 25));
        this.m_jPrice.setRequestFocusEnabled(false);
        this.m_jPor.setFont(new Font("Arial", 0, 12));
        this.m_jPor.setHorizontalAlignment(0);
        this.m_jPor.setRequestFocusEnabled(false);
        this.m_jEnter.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/barcode.png")));
        this.m_jEnter.setToolTipText(bundle.getString("tooltip.salebarcode"));
        this.m_jEnter.setFocusPainted(false);
        this.m_jEnter.setFocusable(false);
        this.m_jEnter.setPreferredSize(new Dimension(80, 45));
        this.m_jEnter.setRequestFocusEnabled(false);
        this.m_jEnter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTicket.this.m_jEnterActionPerformed(evt);
            }
        });
        this.m_jTax.setFont(new Font("Arial", 0, 14));
        this.m_jTax.setToolTipText(bundle.getString("tooltip.salestaxswitch"));
        this.m_jTax.setFocusable(false);
        this.m_jTax.setPreferredSize(new Dimension(28, 25));
        this.m_jTax.setRequestFocusEnabled(false);
        this.m_jKeyFactory.setEditable(false);
        this.m_jKeyFactory.setFont(new Font("Arial", 0, 11));
        this.m_jKeyFactory.setForeground(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setAutoscrolls(false);
        this.m_jKeyFactory.setBorder(null);
        this.m_jKeyFactory.setCaretColor(UIManager.getDefaults().getColor("Panel.background"));
        this.m_jKeyFactory.setMinimumSize(new Dimension(0, 0));
        this.m_jKeyFactory.setPreferredSize(new Dimension(1, 1));
        this.m_jKeyFactory.setRequestFocusEnabled(false);
        this.m_jKeyFactory.setVerifyInputWhenFocusTarget(false);
        this.m_jKeyFactory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelTicket.this.m_jKeyFactoryKeyTyped(evt);
            }
        });
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_jPor).addComponent(this.m_jKeyFactory, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent((Component)this.m_jaddtax, -1, -1, Short.MAX_VALUE).addGap(7, 7, 7).addComponent(this.m_jTax, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.m_jPrice, -1, -1, Short.MAX_VALUE).addGap(5, 5, 5))).addComponent(this.m_jEnter, -2, 71, -2).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.m_jEnter, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.m_jPrice, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_jTax, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent((Component)this.m_jaddtax, GroupLayout.Alignment.TRAILING, -1, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addComponent(this.m_jPor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.m_jKeyFactory, -2, 1, -2)));
        this.m_jPanEntries.add(this.jPanel9);
        this.m_jNumberKeys.setMinimumSize(new Dimension(300, 300));
        this.m_jNumberKeys.setPreferredSize(new Dimension(250, 250));
        this.m_jNumberKeys.addJNumberEventListener(new JNumberEventListener(){

            @Override
            public void keyPerformed(JNumberEvent evt) {
                JPanelTicket.this.m_jNumberKeysKeyPerformed(evt);
            }
        });
        this.m_jPanEntries.add(this.m_jNumberKeys);
        this.m_jContEntries.add((Component)this.m_jPanEntries, "North");
        this.m_jPanContainer.add((Component)this.m_jContEntries, "After");
        this.catcontainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.catcontainer.setFont(new Font("Arial", 0, 14));
        this.catcontainer.setLayout(new BorderLayout());
        this.m_jPanContainer.add((Component)this.catcontainer, "South");
        this.add((Component)this.m_jPanContainer, "ticket");
    }

    private void m_jbtnScaleActionPerformed(ActionEvent evt) {
        this.stateTransition('\u00a7');
    }

    private void m_jEditLineActionPerformed(ActionEvent evt) {
        this.count = (int)this.m_oTicket.getArticlesCount();
        int i = this.m_ticketlines.getSelectedIndex();
        if (i < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                TicketLineInfo newline = JProductLineEdit.showMessage(this, this.m_App, this.m_oTicket.getLine(i));
                if (newline != null) {
                    this.paintTicketLine(i, newline);
                }
            }
            catch (BasicException e) {
                new MessageInf(e).show(this);
            }
        }
    }

    private void m_jEnterActionPerformed(ActionEvent evt) {
        this.stateTransition('\n');
    }

    private void m_jNumberKeysKeyPerformed(JNumberEvent evt) {
        this.stateTransition(evt.getKey());
        this.j_btnRemotePrt.setEnabled(true);
        this.j_btnRemotePrt.revalidate();
    }

    private void m_jKeyFactoryKeyTyped(KeyEvent evt) {
        this.m_jKeyFactory.setText(null);
        this.stateTransition(evt.getKeyChar());
    }

    private void m_jDeleteActionPerformed(ActionEvent evt) {
        int i = this.m_ticketlines.getSelectedIndex();
        if (i < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.removeTicketLine(i);
            this.jCheckStock.setText("");
        }
    }

    private void m_jListActionPerformed(ActionEvent evt) {
        ProductInfoExt prod = JProductFinder.showMessage(this, this.dlSales);
        if (prod != null) {
            this.buttonTransition(prod);
        }
    }

    private void jEditAttributesActionPerformed(ActionEvent evt) {
        int i;
        if (this.listener != null) {
            this.listener.stop();
        }
        if ((i = this.m_ticketlines.getSelectedIndex()) < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                TicketLineInfo line = this.m_oTicket.getLine(i);
                JProductAttEdit2 attedit = JProductAttEdit2.getAttributesEditor(this, this.m_App.getSession());
                attedit.editAttributes(line.getProductAttSetId(), line.getProductAttSetInstId());
                attedit.setVisible(true);
                if (attedit.isOK()) {
                    line.setProductAttSetInstId(attedit.getAttributeSetInst());
                    line.setProductAttSetInstDesc(attedit.getAttributeSetInstDescription());
                    this.paintTicketLine(i, line);
                }
            }
            catch (BasicException ex) {
                JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.cannotfindattributes"), AppLocal.getIntString("message.title"), 1);
            }
        }
        if (this.listener != null) {
            this.listener.restart();
        }
    }

    private void jbtnMooringActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.stop();
        }
        JMooringDetails mooring = JMooringDetails.getMooringDetails(this, this.m_App.getSession());
        mooring.setVisible(true);
        if (mooring.isCreate() && mooring.getVesselDays() > 0 && mooring.getVesselSize() > 1) {
            try {
                ProductInfoExt vProduct = this.dlSales.getProductInfoByCode("BFeesDay1");
                vProduct.setName("Berth Fees 1st Day " + mooring.getVesselName());
                this.addTicketLine(vProduct, mooring.getVesselSize().intValue(), vProduct.getPriceSell());
                if (mooring.getVesselDays() > 1) {
                    vProduct = this.dlSales.getProductInfoByCode("BFeesDay2");
                    vProduct.setName("Additional Days " + (mooring.getVesselDays() - 1));
                    this.addTicketLine(vProduct, mooring.getVesselSize() * (mooring.getVesselDays() - 1), vProduct.getPriceSell());
                }
                if (mooring.getVesselPower().booleanValue()) {
                    vProduct = this.dlSales.getProductInfoByCode("PowerSupplied");
                    this.addTicketLine(vProduct, mooring.getVesselDays().intValue(), vProduct.getPriceSell());
                }
            }
            catch (BasicException basicException) {
                // empty catch block
            }
        }
        this.refreshTicket();
    }

    private void j_btnRemotePrtActionPerformed(ActionEvent evt) {
        String rScript = this.dlSystem.getResourceAsText("script.SendOrder");
        Interpreter i = new Interpreter();
        try {
            i.set("ticket", (Object)this.m_oTicket);
            i.set("place", this.m_oTicketExt);
            i.set("user", (Object)this.m_App.getAppUserView().getUser());
            i.set("sales", (Object)this);
            i.set("pickupid", this.m_oTicket.getPickupId());
            Object object = i.eval(rScript);
        }
        catch (EvalError ex) {
            Logger.getLogger(JPanelTicket.class.getName()).log(Level.ALL, null, ex);
        }
        this.remoteOrderDisplay();
    }

    private void btnReprint1ActionPerformed(ActionEvent evt) {
        block6: {
            if (this.m_config.getProperty("lastticket.number") != null) {
                try {
                    TicketInfo ticket = this.dlSales.loadTicket(Integer.parseInt(this.m_config.getProperty("lastticket.type")), Integer.parseInt(this.m_config.getProperty("lastticket.number")));
                    if (ticket == null) {
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, AppLocal.getIntString("message.notexiststicket"), AppLocal.getIntString("message.notexiststickettitle"), 2);
                        break block6;
                    }
                    this.m_ticket = ticket;
                    this.m_ticketCopy = null;
                    try {
                        this.taxeslogic.calculateTaxes(this.m_ticket);
                        TicketTaxInfo[] frame = this.m_ticket.getTaxLines();
                    }
                    catch (TaxesException frame) {
                        // empty catch block
                    }
                    this.printTicket("Printer.ReprintTicket", this.m_ticket, null);
                    this.Notify("'Printed'");
                }
                catch (BasicException e) {
                    MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotloadticket"), e);
                    msg.show(this);
                }
            }
        }
    }

    private void btnSplitActionPerformed(ActionEvent evt) {
        if (this.m_oTicket.getLinesCount() > 0) {
            ReceiptSplit splitdialog = ReceiptSplit.getDialog(this, this.dlSystem.getResourceAsXML("Ticket.Line"), this.dlSales, this.dlCustomers, this.taxeslogic);
            TicketInfo ticket1 = this.m_oTicket.copyTicket();
            TicketInfo ticket2 = new TicketInfo();
            ticket2.setCustomer(this.m_oTicket.getCustomer());
            if (splitdialog.showDialog(ticket1, ticket2, this.m_oTicketExt) && this.closeTicket(ticket2, this.m_oTicketExt)) {
                this.setActiveTicket(ticket1, this.m_oTicketExt);
            }
        }
    }

    private void jCheckStockActionPerformed(ActionEvent evt) {
        int i;
        if (this.listener != null) {
            this.listener.stop();
        }
        if ((i = this.m_ticketlines.getSelectedIndex()) < 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                TicketLineInfo line = this.m_oTicket.getLine(i);
                String pId = line.getProductID();
                String location = this.m_App.getInventoryLocation();
                ProductStock checkProduct = this.dlSales.getProductStockState(pId, location);
                if (checkProduct != null) {
                    if (checkProduct.getUnits() <= 0.0) {
                        this.jCheckStock.setForeground(Color.magenta);
                    } else {
                        this.jCheckStock.setForeground(Color.darkGray);
                    }
                    if (!location.equals(checkProduct.getLocation())) {
                        String content = AppLocal.getIntString("message.location.current");
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, content, "Info", 1);
                    } else {
                        double dUnits = checkProduct.getUnits();
                        int iUnits = (int)dUnits;
                        this.jCheckStock.setText(Integer.toString(iUnits));
                    }
                } else {
                    this.jCheckStock.setText(null);
                }
            }
            catch (BasicException ex) {
                Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.listener != null) {
            this.listener.restart();
        }
    }

    private void jCheckStockMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int i;
            if (this.listener != null) {
                this.listener.stop();
            }
            if ((i = this.m_ticketlines.getSelectedIndex()) < 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                try {
                    TicketLineInfo line = this.m_oTicket.getLine(i);
                    String pId = line.getProductID();
                    String location = this.m_App.getInventoryLocation();
                    ProductStock checkProduct = this.dlSales.getProductStockState(pId, location);
                    if (!location.equals(checkProduct.getLocation())) {
                        String content = AppLocal.getIntString("message.location.current");
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, content, "Info", 1);
                    } else {
                        Double pMin = checkProduct.getMinimum() != null ? checkProduct.getMinimum() : Double.valueOf(0.0);
                        Double pMax = checkProduct.getMaximum() != null ? checkProduct.getMaximum() : Double.valueOf(0.0);
                        if (checkProduct.getUnits() != null) {
                            Double pUnits = checkProduct.getUnits();
                        } else {
                            Double pUnits = 0.0;
                        }
                        Date pMemoDate = checkProduct.getMemoDate() != null ? checkProduct.getMemoDate() : null;
                        String content = "<html><b>" + AppLocal.getIntString("label.currentstock") + " : </b>" + checkProduct.getUnits() + "<br><b>" + AppLocal.getIntString("label.maximum") + " : </b>" + pMax + "<br><b>" + AppLocal.getIntString("label.minimum") + " : </b>" + pMin + "<br><b>" + AppLocal.getIntString("label.proddate") + " : </b>" + pMemoDate + "<br>";
                        JFrame frame = new JFrame();
                        JOptionPane.showMessageDialog(frame, content, "Info", 1);
                    }
                }
                catch (BasicException ex) {
                    Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.listener != null) {
                this.listener.restart();
            }
        }
    }

    private void m_jaddtaxActionPerformed(ActionEvent evt) {
        this.m_jKeyFactory.requestFocus();
    }

    private void jTBtnShowActionPerformed(ActionEvent evt) {
        if (this.jTBtnShow.isSelected()) {
            this.m_jPanelScripts.setVisible(true);
            this.m_jButtonsExt.setVisible(true);
        } else {
            this.m_jPanelScripts.setVisible(false);
            this.m_jButtonsExt.setVisible(false);
        }
        this.refreshTicket();
        this.m_jKeyFactory.requestFocus();
    }

    private void jBtnCustomerActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.stop();
        }
        Object[] options = new Object[]{"Create", "Find", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, AppLocal.getIntString("message.customeradd"), AppLocal.getIntString("label.customer"), 1, 3, null, options, options[2]);
        if (n == 0) {
            JDialogNewCustomer dialog = JDialogNewCustomer.getDialog(this, this.m_App);
            dialog.setVisible(true);
            CustomerInfoExt m_customerInfo = dialog.getSelectedCustomer();
            if (dialog.getSelectedCustomer() != null) {
                try {
                    this.m_oTicket.setCustomer(this.dlSales.loadCustomerExt(dialog.getSelectedCustomer().getId()));
                }
                catch (BasicException ex) {
                    Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (n == 1) {
            JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlCustomers);
            if (this.m_oTicket.getCustomerId() == null) {
                finder.setAppView(this.m_App);
                finder.search(this.m_oTicket.getCustomer());
                finder.executeSearch();
                finder.setVisible(true);
                if (finder.getSelectedCustomer() != null) {
                    try {
                        this.m_oTicket.setCustomer(this.dlSales.loadCustomerExt(finder.getSelectedCustomer().getId()));
                        if ("restaurant".equals(this.m_App.getProperties().getProperty("machine.ticketsbag"))) {
                            this.restDB.setCustomerNameInTableByTicketId(this.dlSales.loadCustomerExt(finder.getSelectedCustomer().getId()).toString(), this.m_oTicket.getId());
                        }
                        this.checkCustomer();
                        this.m_jTicketId.setText(this.m_oTicket.getName(this.m_oTicketExt));
                    }
                    catch (BasicException e) {
                        MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), e);
                        msg.show(this);
                    }
                } else {
                    this.restDB.setCustomerNameInTableByTicketId(null, this.m_oTicket.getId());
                    this.m_oTicket.setCustomer(null);
                    this.Notify("notify.customerremove");
                }
            } else if (JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.customerchange"), AppLocal.getIntString("title.editor"), 0) == 0) {
                finder.setAppView(this.m_App);
                finder.search(this.m_oTicket.getCustomer());
                finder.executeSearch();
                finder.setVisible(true);
                if (finder.getSelectedCustomer() != null) {
                    try {
                        this.m_oTicket.setCustomer(this.dlSales.loadCustomerExt(finder.getSelectedCustomer().getId()));
                        if ("restaurant".equals(this.m_App.getProperties().getProperty("machine.ticketsbag"))) {
                            this.restDB.setCustomerNameInTableByTicketId(this.dlSales.loadCustomerExt(finder.getSelectedCustomer().getId()).toString(), this.m_oTicket.getId());
                        }
                        this.checkCustomer();
                        this.m_jTicketId.setText(this.m_oTicket.getName());
                    }
                    catch (BasicException e) {
                        MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotfindcustomer"), e);
                        msg.show(this);
                    }
                } else {
                    this.restDB.setCustomerNameInTableByTicketId(null, this.m_oTicket.getId());
                    this.m_oTicket.setCustomer(null);
                }
            }
        }
        this.refreshTicket();
    }

    public void remoteOrderDisplay() {
        this.remoteOrderDisplay(this.remoteOrderId(), 1, true);
    }

    public void remoteOrderDisplay(String id) {
        this.remoteOrderDisplay(id, 1, true);
    }

    public void remoteOrderDisplay(Integer display) {
        this.remoteOrderDisplay(this.remoteOrderId(), display, false);
    }

    public String remoteOrderId() {
        String id = "";
        if (this.m_oTicket.getCustomer() != null) {
            return this.m_oTicket.getCustomer().getName();
        }
        if (this.m_oTicketExt != null) {
            return this.m_oTicketExt.toString();
        }
        if (this.m_oTicket.getPickupId() == 0) {
            try {
                this.m_oTicket.setPickupId(this.dlSales.getNextPickupIndex());
            }
            catch (BasicException e) {
                this.m_oTicket.setPickupId(0);
            }
        }
        return this.getPickupString(this.m_oTicket);
    }

    public void remoteOrderDisplay(String id, Integer display, boolean primary) {
        try {
            this.dlSystem.deleteOrder(id);
        }
        catch (BasicException ex) {
            Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (int i = 0; i < this.m_oTicket.getLinesCount(); ++i) {
            try {
                if (primary) {
                    display = this.m_oTicket.getLine(i).getProperty("display") == null || "".equals(this.m_oTicket.getLine(i).getProperty("display")) ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(this.m_oTicket.getLine(i).getProperty("display")));
                }
                this.dlSystem.addOrder(this.getPickupString(this.m_oTicket), (int)this.m_oTicket.getLine(i).getMultiply(), this.m_oTicket.getLine(i).getProductName(), this.m_oTicket.getLine(i).getProductAttSetInstDesc(), this.m_oTicket.getLine(i).getProperty("notes"), id, null, display, null, null);
                continue;
            }
            catch (BasicException ex) {
                Logger.getLogger(JPanelTicket.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public class ScriptObject {
        private final TicketInfo ticket;
        private final Object ticketext;
        private int selectedindex;

        private ScriptObject(TicketInfo ticket, Object ticketext) {
            this.ticket = ticket;
            this.ticketext = ticketext;
        }

        public double getInputValue() {
            if (JPanelTicket.this.m_iNumberStatusInput == 1 && JPanelTicket.this.m_iNumberStatusPor == 0) {
                return JPanelTicket.this.getInputValue();
            }
            return 0.0;
        }

        public int getSelectedIndex() {
            return this.selectedindex;
        }

        public void setSelectedIndex(int i) {
            this.selectedindex = i;
        }

        public void printReport(String resourcefile) {
            JPanelTicket.this.printReport(resourcefile, this.ticket, this.ticketext);
        }

        public void printTicket(String sresourcename) {
            JPanelTicket.this.printTicket(sresourcename, this.ticket, this.ticketext);
            JPanelTicket.this.j_btnRemotePrt.setEnabled(false);
        }

        public Object evalScript(String code, ScriptArg ... args) throws ScriptException {
            ScriptEngine script = ScriptFactory.getScriptEngine("beanshell");
            String sDBUser = JPanelTicket.this.m_App.getProperties().getProperty("db.user");
            String sDBPassword = JPanelTicket.this.m_App.getProperties().getProperty("db.password");
            if (sDBUser != null && sDBPassword != null && sDBPassword.startsWith("crypt:")) {
                AltEncrypter cypher = new AltEncrypter("cypherkey" + sDBUser);
                sDBPassword = cypher.decrypt(sDBPassword.substring(6));
            }
            script.put("hostname", JPanelTicket.this.m_App.getProperties().getProperty("machine.hostname"));
            script.put("dbURL", JPanelTicket.this.m_App.getProperties().getProperty("db.URL") + JPanelTicket.this.m_App.getProperties().getProperty("db.schema"));
            script.put("dbUser", sDBUser);
            script.put("dbPassword", sDBPassword);
            script.put("ticket", this.ticket);
            script.put("place", this.ticketext);
            script.put("taxes", JPanelTicket.this.taxcollection);
            script.put("taxeslogic", JPanelTicket.this.taxeslogic);
            script.put("user", JPanelTicket.this.m_App.getAppUserView().getUser());
            script.put("sales", this);
            script.put("taxesinc", JPanelTicket.this.m_jaddtax.isSelected());
            script.put("warranty", JPanelTicket.this.warrantyPrint);
            script.put("pickupid", JPanelTicket.this.getPickupString(this.ticket));
            for (ScriptArg arg : args) {
                script.put(arg.getKey(), arg.getValue());
            }
            return script.eval(code);
        }
    }

    public static class ScriptArg {
        private final String key;
        private final Object value;

        public ScriptArg(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class logout
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent ae) {
            JPanelTicket.this.closeAllDialogs();
            switch (JPanelTicket.this.m_App.getProperties().getProperty("machine.ticketsbag")) {
                case "restaurant": {
                    if ("false".equals(JPanelTicket.this.m_App.getProperties().getProperty("till.autoLogoffrestaurant"))) {
                        JPanelTicket.this.deactivate();
                        ((JRootApp)JPanelTicket.this.m_App).closeAppView();
                        break;
                    }
                    JPanelTicket.this.deactivate();
                    JPanelTicket.this.setActiveTicket(null, null);
                    break;
                }
                default: {
                    JPanelTicket.this.deactivate();
                    ((JRootApp)JPanelTicket.this.m_App).closeAppView();
                }
            }
        }
    }
}

