/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.voucher;

import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.ComboBoxValModel;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.data.user.EditorRecord;
import com.openbravo.format.Formats;
import com.openbravo.pos.customers.CustomerInfo;
import com.openbravo.pos.customers.DataLogicCustomers;
import com.openbravo.pos.customers.JCustomerFinder;
import com.openbravo.pos.customers.JDialogNewCustomer;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.DataLogicSystem;
import com.openbravo.pos.util.ValidateBuilder;
import com.openbravo.pos.voucher.JDialogReportPanel;
import com.openbravo.pos.voucher.VoucherInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public final class VoucherEditor
extends JPanel
implements EditorRecord {
    private static final DateFormat m_simpledate = new SimpleDateFormat("MM-yy");
    private Object id;
    private final DataLogicCustomers dlCustomers;
    private final DataLogicSystem dlSystem;
    private CustomerInfo customerInfo;
    private final AppView m_app;
    private final ComboBoxValModel m_ReasonModel;
    private JButton jButtonPrint;
    private JComboBox<String> jCBCustomer;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLblStatus;
    private JTextField m_jAmount;
    private JTextField m_jCustomer;
    private JTextField m_jNumber;
    private JTextField m_jStatus;

    public VoucherEditor(DirtyManager dirty, AppView app) {
        this.m_app = app;
        this.initComponents();
        this.dlCustomers = (DataLogicCustomers)app.getBean("com.openbravo.pos.customers.DataLogicCustomers");
        this.dlSystem = (DataLogicSystem)app.getBean("com.openbravo.pos.forms.DataLogicSystem");
        this.m_jNumber.getDocument().addDocumentListener(dirty);
        this.m_jCustomer.getDocument().addDocumentListener(dirty);
        this.m_jAmount.getDocument().addDocumentListener(dirty);
        this.m_jStatus.getDocument().addDocumentListener(dirty);
        this.jButtonPrint.setVisible(false);
        this.m_ReasonModel = new ComboBoxValModel();
        this.m_ReasonModel.add(AppLocal.getIntString("cboption.find"));
        this.m_ReasonModel.add(AppLocal.getIntString("cboption.create"));
        this.jCBCustomer.setModel(this.m_ReasonModel);
        this.jLblStatus.setIcon(null);
        this.writeValueEOF();
    }

    @Override
    public void writeValueEOF() {
        this.id = null;
        this.m_jNumber.setText(null);
        this.m_jNumber.setEnabled(false);
        this.m_jCustomer.setText(null);
        this.m_jCustomer.setEnabled(false);
        this.m_jAmount.setText(null);
        this.m_jAmount.setEnabled(false);
        this.m_jStatus.setText(null);
        this.m_jStatus.setEnabled(false);
        this.jButtonPrint.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.id = UUID.randomUUID().toString();
        this.m_jNumber.setText(this.generateVoucherNumber());
        this.m_jNumber.setEnabled(true);
        this.m_jCustomer.setText(null);
        this.m_jCustomer.setEnabled(true);
        this.m_jAmount.setText(null);
        this.m_jAmount.setEnabled(true);
        this.m_jStatus.setText(null);
        this.m_jStatus.setText("A");
        this.jButtonPrint.setEnabled(false);
        this.jButtonPrint.setEnabled(true);
    }

    @Override
    public void writeValueDelete(Object value) {
        if ("A".equals(this.m_jStatus.getText())) {
            try {
                Object[] attr = (Object[])value;
                this.id = attr[0];
                this.m_jNumber.setText(Formats.STRING.formatValue(attr[1]));
                this.m_jNumber.setEnabled(false);
                this.customerInfo = this.dlCustomers.getCustomerInfo(attr[2].toString());
                this.m_jCustomer.setText(this.customerInfo.getName());
                this.m_jCustomer.setEnabled(false);
                this.m_jAmount.setText(Formats.DOUBLE.formatValue(attr[3]));
                this.m_jAmount.setEnabled(false);
                this.m_jStatus.setText(Formats.STRING.formatValue(attr[4]));
                this.m_jStatus.setEnabled(false);
                this.jButtonPrint.setEnabled(false);
            }
            catch (BasicException ex) {
                Logger.getLogger(VoucherEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.voucherdelete"), AppLocal.getIntString("Check"), 2);
        }
    }

    @Override
    public void writeValueEdit(Object value) {
        try {
            Object[] attr = (Object[])value;
            this.id = attr[0];
            this.m_jNumber.setText(Formats.STRING.formatValue(attr[1]));
            this.m_jNumber.setEnabled(true);
            this.customerInfo = this.dlCustomers.getCustomerInfo(attr[2].toString());
            this.m_jCustomer.setText(this.customerInfo.getName());
            this.m_jCustomer.setEnabled(true);
            this.m_jAmount.setText(Formats.DOUBLE.formatValue(attr[3]));
            this.m_jAmount.setEnabled(true);
            this.m_jStatus.setText(Formats.STRING.formatValue(attr[4]));
            this.jButtonPrint.setEnabled(true);
            if (null == this.m_jStatus.getText()) {
                this.jLblStatus.setIcon(null);
            } else {
                switch (this.m_jStatus.getText()) {
                    case "A": {
                        this.jLblStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/OK.png")));
                        this.m_jNumber.setEnabled(true);
                        this.m_jAmount.setEnabled(true);
                        this.jCBCustomer.setEnabled(true);
                        this.m_jStatus.setText("A");
                        break;
                    }
                    case "D": {
                        this.jLblStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/refundit.png")));
                        this.m_jNumber.setEnabled(false);
                        this.m_jAmount.setEnabled(false);
                        this.jCBCustomer.setEnabled(false);
                        this.m_jStatus.setText("D");
                        break;
                    }
                    default: {
                        this.jLblStatus.setIcon(null);
                    }
                }
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(VoucherEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] attr = new Object[]{this.id, this.m_jNumber.getText(), this.customerInfo.getId(), Formats.DOUBLE.parseValue(this.m_jAmount.getText()), this.m_jStatus.getText()};
        return attr;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void refresh() {
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.m_jNumber = new JTextField();
        this.jLabel3 = new JLabel();
        this.m_jCustomer = new JTextField();
        this.m_jAmount = new JTextField();
        this.jLabel5 = new JLabel();
        this.jButtonPrint = new JButton();
        this.jLblStatus = new JLabel();
        this.m_jStatus = new JTextField();
        this.jCBCustomer = new JComboBox();
        this.setFont(new Font("Arial", 0, 14));
        this.jLabel2.setFont(new Font("Arial", 0, 14));
        this.jLabel2.setText(AppLocal.getIntString("label.Number"));
        this.jLabel2.setPreferredSize(new Dimension(100, 30));
        this.m_jNumber.setFont(new Font("Arial", 0, 14));
        this.m_jNumber.setPreferredSize(new Dimension(240, 30));
        this.jLabel3.setFont(new Font("Arial", 0, 14));
        this.jLabel3.setText(AppLocal.getIntString("label.customer"));
        this.jLabel3.setPreferredSize(new Dimension(100, 30));
        this.m_jCustomer.setEditable(false);
        this.m_jCustomer.setFont(new Font("Arial", 0, 14));
        this.m_jCustomer.setPreferredSize(new Dimension(240, 30));
        this.m_jAmount.setFont(new Font("Arial", 0, 14));
        this.m_jAmount.setPreferredSize(new Dimension(240, 30));
        this.jLabel5.setFont(new Font("Arial", 0, 14));
        this.jLabel5.setText(AppLocal.getIntString("label.paymenttotal"));
        this.jLabel5.setPreferredSize(new Dimension(100, 30));
        this.jButtonPrint.setFont(new Font("Arial", 0, 12));
        this.jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/printer24.png")));
        this.jButtonPrint.setToolTipText(AppLocal.getIntString("button.print"));
        this.jButtonPrint.setFocusPainted(false);
        this.jButtonPrint.setFocusable(false);
        this.jButtonPrint.setMargin(new Insets(8, 14, 8, 14));
        this.jButtonPrint.setPreferredSize(new Dimension(80, 45));
        this.jButtonPrint.setRequestFocusEnabled(false);
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherEditor.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jLblStatus.setFont(new Font("Arial", 0, 14));
        this.jLblStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/ok.png")));
        this.jLblStatus.setText(AppLocal.getIntString("label.Status"));
        this.jLblStatus.setHorizontalTextPosition(10);
        this.jLblStatus.setPreferredSize(new Dimension(100, 30));
        this.m_jStatus.setFont(new Font("Arial", 0, 14));
        this.m_jStatus.setPreferredSize(new Dimension(240, 30));
        this.jCBCustomer.setFont(new Font("Arial", 0, 14));
        this.jCBCustomer.setMaximumRowCount(2);
        this.jCBCustomer.setModel(new DefaultComboBoxModel<String>(new String[]{"Find", "Create"}));
        this.jCBCustomer.setToolTipText(AppLocal.getIntString("label.voucherCustomer"));
        this.jCBCustomer.setPreferredSize(new Dimension(110, 30));
        this.jCBCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoucherEditor.this.jCBCustomerActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.m_jCustomer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCBCustomer, 0, -1, -2)).addComponent(this.m_jNumber, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.m_jAmount, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLblStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.m_jStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 52, Short.MAX_VALUE).addComponent(this.jButtonPrint, -2, -1, -2).addGap(28, 28, 28)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.m_jNumber, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jCustomer, -2, -1, -2).addComponent(this.jCBCustomer, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.m_jAmount, -2, -1, -2)).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPrint, -2, -1, -2).addComponent(this.jLblStatus, -2, -1, -2).addComponent(this.m_jStatus, -2, -1, -2)).addContainerGap()));
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        try {
            VoucherInfo voucherInfo = this.dlCustomers.getVoucherInfoAll(this.id.toString());
            BufferedImage image = this.dlSystem.getResourceAsImage("Window.Logo");
            if (voucherInfo != null) {
                JDialogReportPanel dialog = JDialogReportPanel.getDialog(this, this.m_app, voucherInfo, image);
                dialog.setVisible(true);
            }
        }
        catch (BasicException basicException) {
            // empty catch block
        }
    }

    private void jCBCustomerActionPerformed(ActionEvent evt) {
        if (this.jCBCustomer.getSelectedIndex() == 0) {
            JCustomerFinder finder = JCustomerFinder.getCustomerFinder(this, this.dlCustomers);
            finder.setVisible(true);
            this.customerInfo = finder.getSelectedCustomer();
            if (finder.getSelectedCustomer() != null) {
                this.m_jCustomer.setText(this.customerInfo.getName());
            }
        } else {
            JDialogNewCustomer dialog = JDialogNewCustomer.getDialog(this, this.m_app);
            dialog.setVisible(true);
            this.customerInfo = dialog.getSelectedCustomer();
            if (dialog.getSelectedCustomer() != null) {
                this.m_jCustomer.setText(this.customerInfo.getName());
            }
        }
    }

    public boolean isDataValid() {
        ValidateBuilder validate = new ValidateBuilder(this);
        validate.setValidate(this.m_jNumber.getText(), ValidateBuilder.IS_NOT_EMPTY, AppLocal.getIntString("message.message.emptynumber"));
        validate.setValidate(this.m_jCustomer.getText(), ValidateBuilder.IS_NOT_EMPTY, AppLocal.getIntString("message.emptycustomer"));
        validate.setValidate(this.m_jAmount.getText(), ValidateBuilder.IS_DOUBLE, AppLocal.getIntString("message.numericamount"));
        validate.setValidate(this.m_jStatus.getText(), ValidateBuilder.IS_NOT_EMPTY, AppLocal.getIntString("message.emptystatus"));
        return validate.getValid();
    }

    public String generateVoucherNumber() {
        String result = "";
        try {
            result = "VO-";
            String date = m_simpledate.format(new Date());
            result = result + date;
            String lastNumber = (String)this.dlCustomers.getVoucherNumber().find((Object)result);
            int newNumber = 1;
            if (lastNumber != null) {
                newNumber = Integer.parseInt(lastNumber) + 1;
            }
            result = result + "-" + this.getNewNumber(newNumber);
            return result;
        }
        catch (BasicException basicException) {
            return result;
        }
    }

    private String getNewNumber(int newNumber) {
        String newNo = newNumber + "";
        String zero = "";
        for (int i = 0; i < 3 - newNo.length(); ++i) {
            zero = zero + "0";
        }
        return zero + newNo;
    }
}

