/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class UniBrowser
extends JFrame {
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnGo = new JButton("Go");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();

    public UniBrowser() {
        this.initComponents();
    }

    private void initComponents() {
        this.createScene();
        ActionListener al = e -> this.loadURL(this.txtURL.getText());
        this.btnGo.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel topBar = new JPanel(new BorderLayout(5, 0));
        topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        topBar.add((Component)this.txtURL, "Center");
        topBar.add((Component)this.btnGo, "East");
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        this.panel.add((Component)topBar, "North");
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(1024, 600));
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    private void createScene() {
        Platform.runLater(() -> {
            WebView view = new WebView();
            this.engine = view.getEngine();
            this.engine.titleProperty().addListener((observable, oldValue, newValue) -> SwingUtilities.invokeLater(() -> this.setTitle((String)newValue)));
            this.engine.setOnStatusChanged(event -> SwingUtilities.invokeLater(() -> this.lblStatus.setText((String)event.getData())));
            this.engine.locationProperty().addListener((ov, oldValue, newValue) -> SwingUtilities.invokeLater(() -> this.txtURL.setText((String)newValue)));
            this.engine.getLoadWorker().workDoneProperty().addListener((observableValue, oldValue, newValue) -> SwingUtilities.invokeLater(() -> this.progressBar.setValue(newValue.intValue())));
            this.engine.getLoadWorker().exceptionProperty().addListener((o, old, value) -> {
                if (this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.panel, value != null ? this.engine.getLocation() + "\n" + value.getMessage() : this.engine.getLocation() + "\nUnexpected error.", "Loading error...", 0));
                }
            });
            this.jfxPanel.setScene(new Scene((Parent)view));
        });
    }

    public void loadURL(String url) {
        Platform.runLater(() -> {
            String tmp = UniBrowser.toURL(url);
            if (tmp == null) {
                tmp = UniBrowser.toURL("http://" + url);
            }
            this.engine.load(tmp);
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            UniBrowser browser = new UniBrowser();
            browser.setVisible(true);
            browser.loadURL("http://unicenta.org/splasher.html");
        });
    }
}

