//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.CategoryProductSalesChart");
report.setReport("/com/openbravo/reports/sales_chart_piesalescat");
report.setResourceBundle("com/openbravo/reports/sales_chart_piesalescat_messages");

report.setSentence("SELECT "+
                   "categories.NAME AS CAT, " +
                   "SUM(ticketlines.UNITS) AS UNITS, " +
                   "SUM(ticketlines.PRICE * ticketlines.UNITS) AS TOTAL " +
                   "FROM ticketlines " +
                   "LEFT OUTER JOIN products ON ticketlines.PRODUCT = products.ID " +
                   "LEFT OUTER JOIN categories ON products.CATEGORY = categories.ID " +
                   "LEFT OUTER JOIN tickets ON ticketlines.TICKET = tickets.ID " +
                   "LEFT OUTER JOIN receipts ON tickets.ID = receipts.ID " +
                   "WHERE LENGTH(categories.NAME) > '1' AND ?(QBF_FILTER) " +
                   "GROUP BY categories.ID, categories.NAME "+
                   "ORDER BY categories.NAME ASC");

report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("CAT", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

report;
