/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.inventory;

import com.alee.extended.button.WebSwitch;
import com.alee.extended.time.ClockType;
import com.alee.extended.time.WebClock;
import com.alee.laf.table.WebTable;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationManager;
import com.alee.managers.notification.WebNotification;
import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.ComboBoxValModel;
import com.openbravo.data.gui.JImageEditor;
import com.openbravo.data.gui.JMessageDialog;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.loader.SentenceExec;
import com.openbravo.data.loader.SentenceList;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.data.user.EditorRecord;
import com.openbravo.format.Formats;
import com.openbravo.pos.catalog.CategoryStock;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.DataLogicSales;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public final class CategoriesEditor
extends JPanel
implements EditorRecord {
    private Object m_oId;
    private Object m_id;
    public String cId;
    private final SentenceList m_sentcat;
    private ComboBoxValModel m_CategoryModel;
    private final SentenceExec m_sentadd;
    private final SentenceExec m_sentdel;
    private List<CategoryStock> categoryStockList;
    private StockTableModel stockModel;
    private final DataLogicSales dlSales;
    private JButton jBtnShowTrans;
    private JInternalFrame jInternalFrame1;
    private JLabel jLblCatOrder;
    private JLabel jLblCatShowName;
    private JLabel jLblCategory;
    private JLabel jLblInCat;
    private JLabel jLblName;
    private JLabel jLblProdCount;
    private JLabel jLblTextTip;
    private JScrollPane jScrollPane2;
    private WebTable jTableCategoryStock;
    private JCheckBox m_jCatNameShow;
    private JTextField m_jCatOrder;
    private JComboBox m_jCategory;
    private JImageEditor m_jImage;
    private JTextField m_jName;
    private JTextField m_jTextTip;
    private WebSwitch webSwtch_InCatalog;

    public CategoriesEditor(AppView app, DirtyManager dirty) {
        this.dlSales = (DataLogicSales)app.getBean("com.openbravo.pos.forms.DataLogicSales");
        this.initComponents();
        this.m_sentcat = this.dlSales.getCategoriesList();
        this.m_CategoryModel = new ComboBoxValModel();
        this.m_sentadd = this.dlSales.getCatalogCategoryAdd();
        this.m_sentdel = this.dlSales.getCatalogCategoryDel();
        this.m_jName.getDocument().addDocumentListener(dirty);
        this.m_jCategory.addActionListener(dirty);
        this.m_jImage.addPropertyChangeListener("image", dirty);
        this.m_jCatNameShow.addActionListener(dirty);
        this.m_jTextTip.getDocument().addDocumentListener(dirty);
        this.m_jCatOrder.getDocument().addDocumentListener(dirty);
        this.webSwtch_InCatalog.addActionListener((ActionListener)dirty);
        this.writeValueEOF();
    }

    @Override
    public void refresh() {
        ArrayList<Object> a;
        try {
            a = this.m_sentcat.list();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotloadlists"), eD);
            msg.show(this);
            a = new ArrayList<Object>();
        }
        a.add(0, null);
        this.m_CategoryModel = new ComboBoxValModel(a);
        this.m_jCategory.setModel(this.m_CategoryModel);
        this.jLblProdCount.setText(null);
    }

    @Override
    public void writeValueEOF() {
        this.m_id = null;
        this.m_jName.setText(null);
        this.m_CategoryModel.setSelectedKey(null);
        this.m_jImage.setImage(null);
        this.m_jName.setEnabled(false);
        this.m_jCategory.setEnabled(false);
        this.m_jImage.setEnabled(false);
        this.webSwtch_InCatalog.isSelected();
        this.m_jTextTip.setText(null);
        this.m_jTextTip.setEnabled(false);
        this.m_jCatNameShow.setSelected(false);
        this.m_jCatNameShow.setEnabled(false);
        this.m_jCatOrder.setText(null);
        this.m_jCatOrder.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.m_id = UUID.randomUUID().toString();
        this.m_jName.setText(null);
        this.m_CategoryModel.setSelectedKey(null);
        this.m_jImage.setImage(null);
        this.m_jName.setEnabled(true);
        this.m_jCategory.setEnabled(true);
        this.m_jImage.setEnabled(true);
        this.webSwtch_InCatalog.setEnabled(false);
        this.m_jTextTip.setText(null);
        this.m_jTextTip.setEnabled(true);
        this.m_jCatNameShow.setSelected(true);
        this.m_jCatNameShow.setEnabled(true);
        this.m_jCatOrder.setText(null);
        this.m_jCatOrder.setEnabled(true);
    }

    @Override
    public void writeValueDelete(Object value) {
        Object[] cat = (Object[])value;
        this.m_id = cat[0];
        this.m_jName.setText(Formats.STRING.formatValue(cat[1]));
        this.m_CategoryModel.setSelectedKey(cat[2]);
        this.m_jImage.setImage((BufferedImage)cat[3]);
        this.m_jTextTip.setText(Formats.STRING.formatValue(cat[4]));
        this.m_jCatNameShow.setSelected((Boolean)cat[5]);
        this.m_jCatOrder.setText(Formats.STRING.formatValue(cat[6]));
        this.m_jName.setEnabled(false);
        this.m_jCategory.setEnabled(false);
        this.m_jImage.setEnabled(false);
        this.webSwtch_InCatalog.setEnabled(false);
        this.m_jTextTip.setEnabled(false);
        this.m_jCatNameShow.setEnabled(false);
        this.m_jCatOrder.setEnabled(false);
        this.stockModel = new StockTableModel(this.getProductOfName((String)this.m_oId));
    }

    @Override
    public void writeValueEdit(Object value) {
        Object[] cat = (Object[])value;
        this.m_id = cat[0];
        this.m_jName.setText(Formats.STRING.formatValue(cat[1]));
        this.m_CategoryModel.setSelectedKey(cat[2]);
        this.m_jImage.setImage((BufferedImage)cat[3]);
        this.m_jTextTip.setText(Formats.STRING.formatValue(cat[4]));
        this.m_jCatNameShow.setSelected((Boolean)cat[5]);
        if (this.m_jCatOrder.getText().length() == 0) {
            this.m_jCatOrder.setText(null);
        }
        this.m_jCatOrder.setText(Formats.STRING.formatValue(cat[6]));
        this.m_jName.setEnabled(true);
        this.m_jCategory.setEnabled(true);
        this.m_jImage.setEnabled(true);
        this.webSwtch_InCatalog.setEnabled(true);
        this.m_jTextTip.setEnabled(true);
        this.m_jCatNameShow.setEnabled(true);
        this.m_jCatOrder.setEnabled(true);
        this.resetTranxTable();
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] cat = new Object[8];
        cat[0] = this.m_id;
        cat[1] = this.m_jName.getText();
        cat[2] = this.m_CategoryModel.getSelectedKey();
        cat[3] = this.m_jImage.getImage();
        cat[4] = this.m_jTextTip.getText();
        cat[5] = this.m_jCatNameShow.isSelected();
        if (this.m_jCatOrder.getText().length() == 0) {
            this.m_jCatOrder.setText(null);
        }
        cat[6] = this.m_jCatOrder.getText();
        return cat;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void resetTranxTable() {
        this.jTableCategoryStock.getColumnModel().getColumn(0).setPreferredWidth(250);
        Font f = new Font("Arial", 1, 14);
        JTableHeader header = this.jTableCategoryStock.getTableHeader();
        header.setFont(f);
        this.jTableCategoryStock.getTableHeader().setReorderingAllowed(true);
        this.jTableCategoryStock.setAutoCreateRowSorter(true);
        this.jTableCategoryStock.repaint();
    }

    private List<CategoryStock> getProductOfName(String pId) {
        try {
            this.categoryStockList = this.dlSales.getCategorysProductList(pId);
        }
        catch (BasicException ex) {
            Logger.getLogger(CategoriesEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<CategoryStock> categoryList = new ArrayList<CategoryStock>();
        for (CategoryStock categoryStock : this.categoryStockList) {
            String categoryId = categoryStock.getCategoryId();
            if (!categoryId.equals(pId)) continue;
            categoryList.add(categoryStock);
        }
        this.repaint();
        this.refresh();
        return categoryList;
    }

    public void Notify(String msg) {
        WebNotification notification = new WebNotification();
        notification.setIcon(NotificationIcon.information);
        notification.setDisplayTime(4000L);
        WebClock clock = new WebClock();
        clock.setClockType(ClockType.timer);
        clock.setTimeLeft(5000L);
        clock.setTimePattern(msg);
        notification.setContent((Component)clock);
        NotificationManager.showNotification((WebNotification)notification);
        clock.start();
    }

    private void initComponents() {
        this.jInternalFrame1 = new JInternalFrame();
        this.jLblName = new JLabel();
        this.m_jName = new JTextField();
        this.jLblCategory = new JLabel();
        this.m_jCategory = new JComboBox();
        this.jLblTextTip = new JLabel();
        this.m_jTextTip = new JTextField();
        this.jLblCatShowName = new JLabel();
        this.m_jCatNameShow = new JCheckBox();
        this.jLblCatOrder = new JLabel();
        this.m_jCatOrder = new JTextField();
        this.jLblInCat = new JLabel();
        this.webSwtch_InCatalog = new WebSwitch();
        this.m_jImage = new JImageEditor();
        this.jBtnShowTrans = new JButton();
        this.jLblProdCount = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableCategoryStock = new WebTable();
        this.jInternalFrame1.setVisible(true);
        this.setFont(new Font("Arial", 0, 14));
        this.setPreferredSize(new Dimension(500, 500));
        this.jLblName.setFont(new Font("Arial", 0, 14));
        this.jLblName.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/info.png")));
        this.jLblName.setText(AppLocal.getIntString("label.namem"));
        this.jLblName.setPreferredSize(new Dimension(125, 30));
        this.jLblName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CategoriesEditor.this.jLblNameMouseClicked(evt);
            }
        });
        this.m_jName.setFont(new Font("Arial", 0, 14));
        this.m_jName.setPreferredSize(new Dimension(250, 30));
        this.jLblCategory.setFont(new Font("Arial", 0, 14));
        this.jLblCategory.setText(AppLocal.getIntString("label.prodcategory"));
        this.jLblCategory.setPreferredSize(new Dimension(125, 30));
        this.m_jCategory.setFont(new Font("Arial", 0, 14));
        this.m_jCategory.setPreferredSize(new Dimension(250, 30));
        this.jLblTextTip.setFont(new Font("Arial", 0, 14));
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jLblTextTip.setText(bundle.getString("label.texttip"));
        this.jLblTextTip.setPreferredSize(new Dimension(125, 30));
        this.m_jTextTip.setFont(new Font("Arial", 0, 14));
        this.m_jTextTip.setPreferredSize(new Dimension(250, 30));
        this.jLblCatShowName.setFont(new Font("Arial", 0, 14));
        this.jLblCatShowName.setText(bundle.getString("label.subcategorytitle"));
        this.jLblCatShowName.setPreferredSize(new Dimension(150, 30));
        this.m_jCatNameShow.setFont(new Font("Arial", 0, 14));
        this.m_jCatNameShow.setSelected(true);
        this.m_jCatNameShow.setPreferredSize(new Dimension(30, 30));
        this.jLblCatOrder.setFont(new Font("Arial", 0, 14));
        this.jLblCatOrder.setHorizontalAlignment(4);
        this.jLblCatOrder.setText(bundle.getString("label.ccatorder"));
        this.jLblCatOrder.setPreferredSize(new Dimension(60, 30));
        this.m_jCatOrder.setFont(new Font("Arial", 0, 14));
        this.m_jCatOrder.setHorizontalAlignment(0);
        this.m_jCatOrder.setPreferredSize(new Dimension(60, 30));
        this.jLblInCat.setFont(new Font("Arial", 0, 14));
        this.jLblInCat.setHorizontalAlignment(2);
        this.jLblInCat.setText(bundle.getString("label.CatalogueStatusYes"));
        this.jLblInCat.setHorizontalTextPosition(2);
        this.jLblInCat.setPreferredSize(new Dimension(125, 30));
        this.webSwtch_InCatalog.setFont(new Font("Arial", 0, 14));
        this.webSwtch_InCatalog.setPreferredSize(new Dimension(80, 30));
        this.webSwtch_InCatalog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoriesEditor.this.webSwtch_InCatalogActionPerformed(evt);
            }
        });
        this.jBtnShowTrans.setFont(new Font("Arial", 0, 14));
        this.jBtnShowTrans.setText(bundle.getString("button.CatProds"));
        this.jBtnShowTrans.setToolTipText("");
        this.jBtnShowTrans.setPreferredSize(new Dimension(140, 30));
        this.jBtnShowTrans.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoriesEditor.this.jBtnShowTransActionPerformed(evt);
            }
        });
        this.jLblProdCount.setFont(new Font("Arial", 0, 14));
        this.jLblProdCount.setHorizontalAlignment(0);
        this.jLblProdCount.setOpaque(true);
        this.jLblProdCount.setPreferredSize(new Dimension(237, 30));
        this.jScrollPane2.setFont(new Font("Arial", 0, 14));
        this.jScrollPane2.setPreferredSize(new Dimension(340, 502));
        this.jTableCategoryStock.setAutoCreateRowSorter(true);
        this.jTableCategoryStock.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Name", "Barcode"}));
        this.jTableCategoryStock.setFont(new Font("Arial", 0, 14));
        this.jTableCategoryStock.setGridColor(new Color(102, 204, 255));
        this.jTableCategoryStock.setRowHeight(25);
        this.jTableCategoryStock.setSelectionBackground(new Color(0, 120, 215));
        this.jTableCategoryStock.setShowVerticalLines(false);
        this.jScrollPane2.setViewportView((Component)this.jTableCategoryStock);
        if (this.jTableCategoryStock.getColumnModel().getColumnCount() > 0) {
            this.jTableCategoryStock.getColumnModel().getColumn(0).setPreferredWidth(250);
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLblInCat, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.webSwtch_InCatalog, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblName, -2, -1, -2).addComponent(this.jLblCategory, -2, -1, -2)).addComponent(this.jLblTextTip, GroupLayout.Alignment.LEADING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_jName, -2, -1, -2).addComponent(this.m_jTextTip, -2, -1, -2).addComponent(this.m_jCategory, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLblCatShowName, -2, -1, -2).addGap(18, 18, 18).addComponent(this.m_jCatNameShow, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLblCatOrder, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jCatOrder, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jBtnShowTrans, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblProdCount, -1, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addComponent(this.m_jImage, -2, 263, -2)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jName, -2, -1, -2).addComponent(this.jLblName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jCategory, -2, -1, -2).addComponent(this.jLblCategory, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jTextTip, -2, -1, -2).addComponent(this.jLblTextTip, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblInCat, -2, -1, -2).addComponent((Component)this.webSwtch_InCatalog, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblCatShowName, -2, -1, -2).addComponent(this.m_jCatNameShow, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblCatOrder, -2, -1, -2).addComponent(this.m_jCatOrder, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLblProdCount, -1, -1, Short.MAX_VALUE).addComponent(this.jBtnShowTrans, -1, 32, Short.MAX_VALUE))).addComponent(this.m_jImage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 231, Short.MAX_VALUE).addContainerGap()));
    }

    private void webSwtch_InCatalogActionPerformed(ActionEvent evt) {
        if (this.webSwtch_InCatalog.isSelected()) {
            try {
                Object param = this.m_id;
                this.m_sentdel.exec(param);
                this.m_sentadd.exec(param);
                this.jLblInCat.setText(AppLocal.getIntString("label.CatalogueStatusYes"));
                this.Notify(AppLocal.getIntString("notify.added"));
            }
            catch (BasicException e) {
                JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"), e));
            }
        } else {
            try {
                this.m_sentdel.exec(this.m_id);
                this.jLblInCat.setText(AppLocal.getIntString("label.CatalogueStatusNo"));
                this.Notify(AppLocal.getIntString("notify.removed"));
            }
            catch (BasicException e) {
                JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.cannotexecute"), e));
            }
        }
    }

    private void jLblNameMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String uuidString = this.m_id.toString();
            StringSelection stringSelection = new StringSelection(uuidString);
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
            JOptionPane.showMessageDialog(null, AppLocal.getIntString("message.uuidcopy"));
        }
    }

    private void jBtnShowTransActionPerformed(ActionEvent evt) {
        String pId = this.m_id.toString();
        if (pId != null) {
            this.stockModel = new StockTableModel(this.getProductOfName(pId));
            this.jTableCategoryStock.setModel((TableModel)this.stockModel);
            if (this.stockModel.getRowCount() > 0) {
                this.jTableCategoryStock.setVisible(true);
                String ProdCount = String.valueOf(this.stockModel.getRowCount());
                this.jLblProdCount.setText(ProdCount + " for " + this.m_jName.getText());
            } else {
                this.jTableCategoryStock.setVisible(false);
                JOptionPane.showMessageDialog(null, "No Products for this Category", "Products", 1);
            }
            this.resetTranxTable();
        }
    }

    class StockTableModel
    extends AbstractTableModel {
        String nam = AppLocal.getIntString("label.prodname");
        String cod = AppLocal.getIntString("label.prodbarcode");
        List<CategoryStock> stockList;
        String[] columnNames = new String[]{this.nam, this.cod};

        public StockTableModel(List<CategoryStock> list) {
            this.stockList = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.stockList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            CategoryStock categoryStock = this.stockList.get(row);
            switch (column) {
                case 0: {
                    return categoryStock.getProductName();
                }
                case 1: {
                    return categoryStock.getProductCode();
                }
                case 2: {
                    return categoryStock.getProductId();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }
}

