//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Products");
report.setReport("/com/openbravo/reports/products");
report.setResourceBundle("com/openbravo/reports/products_messages");

report.setSentence("SELECT products.ID, "
        + "products.REFERENCE, "
        + "products.CODE, "
        + "products.NAME, "
        + "products.PRICEBUY, "
        + "products.PRICESELL, "
        + "T.ID AS TAX, "
        + "T.RATE + 1 AS TAXRATE, "
        + "categories.ID AS CATEGORY, "
        + "categories.NAME AS CATEGORYNAME, "
        + "stockcurrent.UNITS "
    + "FROM ((products products "
        + "INNER JOIN stockcurrent stockcurrent "
            + "ON (products.ID = stockcurrent.PRODUCT)) "
        + "LEFT OUTER JOIN categories categories "
           + "ON (products.CATEGORY = categories.ID)) "
        + "LEFT OUTER JOIN taxes T "
           + "ON (products.TAXCAT = T.ID) "
    + "WHERE ?(QBF_FILTER) "
    + "GROUP BY products.ID "
    + "ORDER BY CATEGORYNAME ASC, products.NAME ASC");

report.addParameter("products.NAME");
report.addParameter("products.CATEGORY");
report.addParameter("products.CODE");
report.addParameter("stockcurrent.UNITS");
report.addQBFFilter(new com.openbravo.pos.ticket.ProductFilter1());

// report.addParameter("suppliers.ID");
// report.addParameter("suppliers.NAME");
// report.addQBFFilter(new com.openbravo.pos.reports.JParamsSuppliers());

report.addParameter("stockcurrent.LOCATION");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsLocationWithFirst());

report.addField("ID", com.openbravo.data.loader.Datas.STRING);
report.addField("REFERENCE", com.openbravo.data.loader.Datas.STRING);
report.addField("CODE", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("PRICEBUY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("PRICESELL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TAX", com.openbravo.data.loader.Datas.STRING);
report.addField("TAXRATE", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("CATEGORY", com.openbravo.data.loader.Datas.STRING);
report.addField("CATEGORYNAME", com.openbravo.data.loader.Datas.STRING);
report.addField("UNITS", com.openbravo.data.loader.Datas.DOUBLE);

report;