//    uniCenta oPOS  - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//   uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.ExtendedCashRegisterLog");
report.setReport("/com/openbravo/reports/sales_extendedcashregisterlog");
report.setResourceBundle("com/openbravo/reports/sales_extendedcashregisterlog_messages");

report.setSentence("SELECT " +
        "tickets.TICKETID AS TICKET_NO, " +
        "receipts.DATENEW AS TICKET_DATE, " +
        "people.NAME AS PERSON, " +
        "payments.PAYMENT AS PAYMENT, " +
        "payments.NOTES, " +
        "payments.TOTAL AS MONEY, " +
        "payments.TENDERED " +
    "FROM ((tickets tickets " +
        "LEFT OUTER JOIN people people ON (tickets.PERSON = people.ID)) " +
        "RIGHT OUTER JOIN receipts receipts ON (receipts.ID = tickets.ID)) " +
        "LEFT OUTER JOIN payments payments ON (receipts.ID = payments.RECEIPT) " +
    "WHERE ?(QBF_FILTER) " +
        "ORDER BY TICKET_DATE ASC");

report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("TICKET_NO", com.openbravo.data.loader.Datas.STRING);
report.addField("TICKET_DATE", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("PERSON", com.openbravo.data.loader.Datas.STRING);
report.addField("PAYMENT", com.openbravo.data.loader.Datas.STRING);
report.addField("NOTES", com.openbravo.data.loader.Datas.STRING);
report.addField("MONEY", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TENDERED", com.openbravo.data.loader.Datas.DOUBLE);

return report;
