//    uniCenta oPOS - touch friendly EPoS
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

// added by g.irura @ 27/03/2010. If a retailer issues item which is 
// taxable but gets back a refund, means when this happens, the tax 
// effected initially is deducted. all taxes occur in taxlines.amount 
// where the sum is obtained. It is therefore important to show on this 
// report the taxes that were charged on a receipt but later refunded

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.SaleTaxes");
report.setReport("/com/openbravo/reports/sales_saletaxes");
report.setResourceBundle("com/openbravo/reports/sales_saletaxes_messages");

report.setSentence(
                "SELECT tickets.TICKETID,receipts.DATENEW, payments.PAYMENT, " +
                    "taxcategories.NAME, taxlines.AMOUNT, taxlines.BASE "+
                "FROM receipts, taxlines, taxes, taxcategories,tickets, payments " +
                "WHERE payments.RECEIPT = receipts.ID AND " +
                    "receipts.ID = taxlines.RECEIPT AND receipts.ID=tickets.ID AND " +
                    "taxlines.TAXID = taxes.ID AND taxes.CATEGORY = taxcategories.ID AND ?(QBF_FILTER) "+
                "ORDER BY receipts.DATENEW");

report.addParameter("receipts.DATENEW");
report.addParameter("receipts.DATENEW");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("TICKETID", com.openbravo.data.loader.Datas.INT);
report.addField("DATENEW", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("PAYMENT", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);
report.addField("AMOUNT", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("BASE", com.openbravo.data.loader.Datas.DOUBLE);
report;