//    uniCenta oPOS - Touch Friendly Point Of Sale
//    Copyright (c) 2009-2018 uniCenta & previous Openbravo POS works
//    https://unicenta.com
//
//    This file is part of uniCenta oPOS
//
//    uniCenta oPOS is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    uniCenta oPOS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with uniCenta oPOS.  If not, see <http://www.gnu.org/licenses/>.

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.Closing");
report.setReport("/com/openbravo/reports/sales_closedpos");
report.setResourceBundle("com/openbravo/reports/sales_closedpos_messages");

report.setSentence("SELECT " + 
                    "closedcash.HOST, " +
                    "closedcash.HOSTSEQUENCE, " +
                    "closedcash.MONEY, " +
                    "closedcash.DATESTART, " +
                    "closedcash.DATEEND, " +
                    "payments.PAYMENT, " +
                    "SUM(payments.TOTAL) AS TOTAL " +
                    "FROM closedcash, payments, receipts " +
                    "WHERE closedcash.MONEY = receipts.MONEY AND payments.RECEIPT = receipts.ID AND ?(QBF_FILTER) " +
                    "GROUP BY closedcash.HOST, closedcash.HOSTSEQUENCE, closedcash.MONEY, closedcash.DATESTART, closedcash.DATEEND, payments.PAYMENT " +
                    "ORDER BY closedcash.HOST, closedcash.HOSTSEQUENCE");

report.addParameter("closedcash.DATEEND");
report.addParameter("closedcash.DATEEND");

paramdates = new com.openbravo.pos.reports.JParamsDatesInterval();

paramdates.setStartDate(com.openbravo.beans.DateUtils.getToday());
// JG - 8 Jan 14 paramdates.setEndDate(com.openbravo.beans.DateUtils.getToday());
paramdates.setEndDate(com.openbravo.beans.DateUtils.getTodayMinutes());

report.addQBFFilter(paramdates);

report.addField("HOST", com.openbravo.data.loader.Datas.STRING);
report.addField("HOSTSEQUENCE", com.openbravo.data.loader.Datas.INT);
report.addField("MONEY", com.openbravo.data.loader.Datas.STRING);
report.addField("DATESTART", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("DATEEND", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("PAYMENT", com.openbravo.data.loader.Datas.STRING);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);

report;

